# sol

Sistema de Operaciones Logísticas

Movimientos INBOUND

Son los movimientos operativos de entrada al depósito que se generan al confirmar un packing list.
Cada fila representa el “viaje” de un pallet desde el estado lógico “recibido” hasta su ubicación inicial en el depósito. 
En nuestro caso, al confirmar, todos los pallets se ubican en la posición de CUARENTENA y el movimiento queda marcado como DONE/FINALIZADO.
Campos clave:

Move code: identificador del movimiento (incluye el ID del ingreso y del pallet).

Tipo/Status: siempre INBOUND y estado final del proceso (ej. DONE).

Pallet / Posición: código del pallet afectado y su posición actual (CUARENTENA).

Tiempos: inicio y fin del movimiento (para medir desempeño).

Pallets del ingreso

Es el resumen por pallet que se generó a partir del packing list confirmado.
Te muestra cada pallet con su posición actual y un consolidado de cantidades:

Ítems: cuántas líneas/partidas tiene ese pallet (SKU/lote).

UV total: total de Unidades de Venta (cajas) del pallet.

UC totales: total de Unidades de Consumo (piezas) del pallet; se calcula como uc_por_caja × uv_cajas + uc_sueltas.

Definiciones rápidas:
UV (Unidades de Venta) = cajas.
UC (Unidades de Consumo) = unidades sueltas / piezas.
uc_por_caja = cuántas unidades trae cada caja.

Ítems (detalle)

Es el detalle línea a línea de lo que hay dentro de los pallets de ese ingreso.
Cada fila corresponde a un SKU (producto) con su lote, fechas (producción/vencimiento, si aplica) y cantidades:

UV cajas (cajas por línea)

UC x caja (unidades por caja)

UC sueltas (unidades fuera de caja)

UC totales (resultado: UC x caja × UV cajas + UC sueltas)

Textos cortos para usar como descripciones en la vista

Puedes copiar/pegar estos textos sobre cada tabla:

Movimientos INBOUND

Registra los movimientos de entrada generados al confirmar el packing list. Cada fila corresponde a un pallet ubicado en CUARENTENA, con tiempos y estado del movimiento.

Pallets del ingreso

Resumen por pallet del ingreso: posición actual, cantidad de ítems y consolidado de cantidades (UV=cajas, UC=unidades). Útil para control rápido de lo recibido.

Ítems

Detalle de productos por pallet (SKU, lote, fechas). Incluye cantidades en UV (cajas) y UC (unidades), además del total calculado por línea.

## Publishing to GitHub (clean)

Suggested steps to create a clean GitHub repository without vendor, node_modules, public assets, or .env files.

- Verify `.gitignore` excludes: `vendor/`, `node_modules/`, `public/assets/`, `public/assets1/`, and `.env`.
- Locally initialize and commit the repo:

  git init
  git add .
  git commit -m "Initial import"

- Create a GitHub repository (example using GitHub CLI):

  gh repo create <your-org-or-user>/sol --public --source=. --remote=origin
  git push -u origin main

If you already have an existing repository with unwanted files in history, use a fresh repo or use `git filter-repo` to rewrite history.

## Creating a sanitized export for GitHub or sharing

If you want to create a copy of this repository without large dependencies and without secrets, there's a helper PowerShell script at `scripts/create_sanitized_export.ps1`.

Usage (PowerShell):

```powershell
cd C:\laragon\www\sol
# Preview what would be done without copying/compressing
.
\scripts\create_sanitized_export.ps1 -ShowOnly
# Run and create sanitized zip
.
\scripts\create_sanitized_export.ps1
```

The script excludes these paths and files by default:
- `vendor/` and `vendor/vendor/`
- `node_modules/`
- `public/assets/` and `public/assets1/`
- `.git/`
- `.env` and `.env.*`

It will produce a `sol-sanitized-<timestamp>.zip` file in the project root.

If you prefer, you can instead create a new GitHub repository and push this project directly — see `scripts/publish_github.ps1` for safe copy/paste commands that do not execute automatically.
