<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Obtener todos los depósitos activos
    $sql = "
        SELECT 
            id,
            code,
            nombre
        FROM wh_deposito
        WHERE activo = 1
        ORDER BY code
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $depositos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['ok'=>true, 'data'=>$depositos]);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok'=>false,
        'error'=>'Error listando depósitos',
        'msg'=>(env('APP_ENV')==='local') ? $e->getMessage() : ''
    ]);
}