<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'No autorizado']);
  exit;
}

try {
  $id = (int)($_POST['id'] ?? 0);
  
  if ($id <= 0) {
    throw new InvalidArgumentException('ID inválido');
  }

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // Verificar que existe y está en estado editable
  $st = $pdo->prepare("SELECT estado FROM inv_conteos WHERE id = ? AND deleted_at IS NULL");
  $st->execute([$id]);
  $conteo = $st->fetch(PDO::FETCH_ASSOC);

  if (!$conteo) {
    throw new RuntimeException('Conteo no encontrado');
  }

  if (!in_array($conteo['estado'], ['BORRADOR', 'EN_PROCESO'])) {
    throw new RuntimeException('No se puede eliminar un conteo finalizado o aprobado');
  }

  // Soft delete
  $st = $pdo->prepare("UPDATE inv_conteos SET deleted_at = NOW() WHERE id = ?");
  $st->execute([$id]);

  // También los items (por FK CASCADE se eliminan automáticamente, pero hacemos soft delete)
  $st = $pdo->prepare("UPDATE inv_conteo_items SET deleted_at = NOW() WHERE conteo_id = ?");
  $st->execute([$id]);

  echo json_encode(['ok' => true, 'message' => 'Conteo eliminado correctamente']);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok' => false,
    'error' => $e->getMessage()
  ]);
}
