<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'No autorizado']);
  exit;
}

try {
  $id = (int)($_GET['id'] ?? 0);
  
  if ($id <= 0) {
    throw new InvalidArgumentException('ID inválido');
  }

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $sql = "SELECT 
            c.id,
            c.codigo,
            c.fecha_conteo,
            c.deposito_id,
            c.cliente_id,
            c.tipo,
            c.estado,
            c.observaciones,
            d.code AS deposito_code,
            d.nombre AS deposito_nombre,
            cl.razon_social AS cliente_nombre,
            u.email AS usuario_email,
            c.created_at
          FROM inv_conteos c
          INNER JOIN wh_deposito d ON d.id = c.deposito_id
          LEFT JOIN para_clientes cl ON cl.id = c.cliente_id
          INNER JOIN sys_users u ON u.id = c.user_id
          WHERE c.id = :id AND c.deleted_at IS NULL";
  
  $st = $pdo->prepare($sql);
  $st->execute([':id' => $id]);
  
  $row = $st->fetch(PDO::FETCH_ASSOC);
  
  if (!$row) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Conteo no encontrado']);
    exit;
  }

  echo json_encode(['ok' => true, 'data' => $row]);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok' => false,
    'error' => $e->getMessage()
  ]);
}
