<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'No autorizado']);
  exit;
}

try {
  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // Filtros
  $estado = trim((string)($_GET['estado'] ?? ''));
  $tipo   = trim((string)($_GET['tipo'] ?? ''));

  $where = ["c.deleted_at IS NULL"];
  $params = [];

  if ($estado !== '') {
    $where[] = "c.estado = :estado";
    $params[':estado'] = $estado;
  }
  if ($tipo !== '') {
    $where[] = "c.tipo = :tipo";
    $params[':tipo'] = $tipo;
  }

  $whereSql = implode(' AND ', $where);

  $sql = "
    SELECT 
      c.id,
      c.codigo,
      c.fecha_conteo,
      c.estado,
      c.tipo,
      d.code AS deposito,
      cli.razon_social AS cliente,
      c.observaciones,
      COUNT(ci.id) AS items_count,
      SUM(ci.total_unidades) AS total_unidades,
      u.username AS creado_por,
      c.created_at,
      c.updated_at
    FROM inv_conteos c
    LEFT JOIN wh_deposito d ON d.id = c.deposito_id
    LEFT JOIN para_clientes cli ON cli.id = c.cliente_id
    LEFT JOIN inv_conteo_items ci ON ci.conteo_id = c.id AND ci.deleted_at IS NULL
    LEFT JOIN sys_users u ON u.id = c.user_id
    WHERE $whereSql
    GROUP BY c.id
    ORDER BY c.fecha_conteo DESC, c.created_at DESC
  ";

  $st = $pdo->prepare($sql);
  foreach ($params as $k => $v) {
    $st->bindValue($k, $v);
  }
  $st->execute();
  $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

  echo json_encode(['ok' => true, 'data' => $rows], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok' => false,
    'error' => 'Error cargando conteos',
    'message' => $e->getMessage()
  ]);
}
