<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'No autorizado']);
  exit;
}

try {
  $input = json_decode(file_get_contents('php://input'), true);
  $id = (int)($input['id'] ?? 0);

  if ($id <= 0) {
    throw new InvalidArgumentException('ID inválido');
  }

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  // Eliminar físicamente el item (no soft delete para items)
  $sql = "DELETE FROM inv_conteo_items WHERE id = :id";
  $st = $pdo->prepare($sql);
  $st->execute([':id' => $id]);

  if ($st->rowCount() === 0) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Item no encontrado']);
    exit;
  }

  echo json_encode(['ok' => true, 'message' => 'Item eliminado']);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok' => false,
    'error' => $e->getMessage()
  ]);
}
