<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'No autorizado']);
  exit;
}

try {
  $conteo_id = (int)($_GET['conteo_id'] ?? 0);
  
  if ($conteo_id <= 0) {
    echo json_encode(['ok' => true, 'data' => []]);
    exit;
  }

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $sql = "SELECT 
            i.id,
            i.conteo_id,
            i.producto_id,
            p.sku,
            p.denominacion,
            (SELECT unidades_por_uv FROM para_producto_pack WHERE producto_id = p.id LIMIT 1) AS uc_por_caja,
            (SELECT cajas_por_pallet FROM para_producto_paletizado WHERE producto_id = p.id LIMIT 1) AS cajas_por_pallet,
            i.lote,
            i.posicion,
            i.cantidad_pallets,
            i.cantidad_cajas,
            i.cantidad_unidades,
            i.total_unidades,
            i.observaciones
          FROM inv_conteo_items i
          INNER JOIN para_productos p ON p.id = i.producto_id
          WHERE i.conteo_id = :conteo_id
          ORDER BY p.sku, p.denominacion";
  
  $st = $pdo->prepare($sql);
  $st->execute([':conteo_id' => $conteo_id]);
  
  $items = $st->fetchAll(PDO::FETCH_ASSOC);

  echo json_encode(['ok' => true, 'data' => $items]);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok' => false,
    'error' => $e->getMessage()
  ]);
}
