<?php
declare(strict_types=1);
header('Content-Type: application/json');

require_once dirname(__DIR__, 2) . '/config/db.php';

try {
    $pdo = getPDO();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $sql = "SELECT id, code, nombre, descripcion, activo
            FROM wh_deposito
            WHERE (deleted_at IS NULL)
              AND (activo = 1 OR activo IS NULL)
            ORDER BY code";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute();
    $depositos = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($depositos, JSON_PRETTY_PRINT);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => 'Error al listar depósitos',
        'detail' => $e->getMessage()
    ]);
}
