<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/db.php';
session_start();

try { $pdo = getPDO(); } catch (Throwable $e) {
  http_response_code(500); echo json_encode(['ok'=>false,'error'=>'db']); exit;
}

$raw = file_get_contents('php://input');
$body = json_decode($raw, true);
$items = is_array($body['items'] ?? null) ? $body['items'] : [];

if (!$items) { http_response_code(422); echo json_encode(['ok'=>false,'error'=>'payload vacío']); exit; }

$userId = (int)($_SESSION['user_id'] ?? 0);

try {
  $pdo->beginTransaction();

  $ins = $pdo->prepare("
    INSERT INTO wh_move
      (deposito_id, tipo, motivo, pallet_id, producto_id, lote_id, from_pos_id, to_pos_id, delta_uv, delta_uc, referencia, user_id, created_at)
    VALUES
      (:dep, 'MOVE', :motivo, :pallet_id, :producto_id, :lote_id, :from_pos_id, :to_pos_id, :delta_uv, :delta_uc, :ref, :user_id, NOW())
  ");

  // Helper: detectar columna de posición en wh_pallet
  $palletPosCol = null;
  try {
    $stCol = $pdo->query("SHOW COLUMNS FROM wh_pallet LIKE 'posicion_id'");
    if ($stCol && $stCol->fetch(PDO::FETCH_ASSOC)) { $palletPosCol = 'posicion_id'; }
    if (!$palletPosCol) {
      $stCol = $pdo->query("SHOW COLUMNS FROM wh_pallet LIKE 'pos_id'");
      if ($stCol && $stCol->fetch(PDO::FETCH_ASSOC)) { $palletPosCol = 'pos_id'; }
    }
  } catch (Throwable $e) { $palletPosCol = 'posicion_id'; }
  if (!$palletPosCol) { $palletPosCol = 'posicion_id'; }

  // Set de posiciones a recalcular ocupación/picked
  $positionsToRecalc = [];

  foreach ($items as $it) {
    // Preferimos el depósito de ORIGEN; si no, intento deposito_id; por último deposito_to
    $depId     = (int)($it['deposito_from'] ?? $it['deposito_id'] ?? $it['deposito_to'] ?? 0);
    $fromPosId = (int)($it['from_pos_id'] ?? 0);
    $toPosId   = (int)($it['to_pos_id'] ?? 0);
    $pallets   = is_array($it['pallets'] ?? null) ? $it['pallets'] : [];
    $updPallet = $pdo->prepare("UPDATE wh_pallet SET posicion_id = :toPos WHERE id = :pid");

    if ($depId <= 0) {
      throw new Exception('deposito_id inválido');
    }

    foreach ($pallets as $p) {
      $ins->execute([
        ':dep'         => $depId,
        ':motivo'      => 'REORDEN_ROTACION', // ajustá si querés
        ':pallet_id'   => (int)($p['id'] ?? 0),
        ':producto_id' => !empty($p['producto_id']) ? (int)$p['producto_id'] : null,
        ':lote_id'     => !empty($p['lote_id']) ? (int)$p['lote_id'] : null,
        ':from_pos_id' => $fromPosId,
        ':to_pos_id'   => $toPosId,
        ':delta_uv'    => (int)($p['uv'] ?? 0),
        ':delta_uc'    => (int)($p['uc'] ?? 0),
        ':ref'         => 'plan-rotacion',
        ':user_id'     => $userId ?: null
      ]);

        // actualizar posición del pallet en el stock en vivo
        $pid = (int)($p['id'] ?? 0);
        if ($pid && $toPosId) {
          $updPallet->execute([':toPos' => $toPosId, ':pid' => $pid]);
        }
    }

    // (Opcional) aquí podrías actualizar pos del pallet, stock, etc.
    // UPDATE wh_pallet SET pos_id = :toPos WHERE id IN (...)
      if ($fromPosId) { $positionsToRecalc[$fromPosId] = true; }
      if ($toPosId)   { $positionsToRecalc[$toPosId]   = true; }
  }

    // Recalcular ocupado/picked en posiciones afectadas
    if (!empty($positionsToRecalc)) {
      // Preparar statements dinámicos respetando la columna detectada
      $countSql = "SELECT COUNT(*) AS c FROM wh_pallet WHERE $palletPosCol = :pos AND (deleted_at IS NULL)";
      $stCount  = $pdo->prepare($countSql);
      $stUpdPos = $pdo->prepare("UPDATE wh_posicion SET ocupado=:occ, picked=:picked, updated_at=NOW() WHERE id=:pos");

      foreach (array_keys($positionsToRecalc) as $posId) {
        $stCount->execute([':pos' => (int)$posId]);
        $c = (int)($stCount->fetchColumn() ?: 0);
        $occ = $c > 0 ? 1 : 0;
        $picked = $c > 1 ? 1 : 0; // criterio: más de un pallet => picked=1
        $stUpdPos->execute([':occ' => $occ, ':picked' => $picked, ':pos' => (int)$posId]);
      }
    }

  $pdo->commit();
  echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
  $pdo->rollBack();
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'tx','debug'=>$e->getMessage()]);
}
