<?php
/**
 * SOL · API · Crear movimiento de depósito (MOVE)
 * Ruta: api/deposito/move_create.php
 */
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado']);
    exit;
}

try {
    $pdo = getPDO();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Recibir datos por POST
    $pallet_id    = intval($_POST['pallet_id'] ?? 0);
    $from_pos_id  = intval($_POST['from_pos_id'] ?? 0);
    $to_pos_id    = intval($_POST['to_pos_id'] ?? 0);
    $deposito_id  = intval($_POST['deposito_id'] ?? 0);
    $motivo       = trim($_POST['motivo'] ?? 'REPOSICION');
    $delta_uv     = intval($_POST['delta_uv'] ?? 0);
    $delta_uc     = intval($_POST['delta_uc'] ?? 0);
    $referencia   = trim($_POST['referencia'] ?? '');
    $user_id      = intval($_SESSION['usuario_id']);

    // Validaciones mínimas
    if (!$pallet_id || !$from_pos_id || !$to_pos_id || !$deposito_id) {
        throw new Exception('Datos incompletos');
    }
    if ($from_pos_id === $to_pos_id) {
        throw new Exception('La posición origen y destino deben ser distintas');
    }

    // Insertar movimiento
    $sql = "INSERT INTO wh_move
        (deposito_id, tipo, motivo, pallet_id, from_pos_id, to_pos_id, delta_uv, delta_uc, referencia, user_id, created_at)
        VALUES (?, 'MOVE', ?, ?, ?, ?, ?, ?, ?, ?, NOW())";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $deposito_id,
        $motivo,
        $pallet_id,
        $from_pos_id,
        $to_pos_id,
        $delta_uv,
        $delta_uc,
        $referencia,
        $user_id
    ]);
    $move_id = $pdo->lastInsertId();

    echo json_encode(['ok' => true, 'move_id' => $move_id]);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['ok' => false, 'error' => $e->getMessage()]);
}
