<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/db.php';

$posId = isset($_GET['pos_id']) ? (int)$_GET['pos_id'] : 0;
if ($posId <= 0) { http_response_code(422); echo json_encode(['ok'=>false,'error'=>'pos_id requerido']); exit; }

try { $pdo = getPDO(); } catch (Throwable $e) { http_response_code(500); echo json_encode(['ok'=>false,'error'=>'db']); exit; }

// TODO: Ajustar nombres de tablas/columnas a tu modelo real
// Suposición: existe wh_pallet con pos_id, code, producto_id, lote_id, uv, uc, etc.
$sql = "
  SELECT
    p.id,
    p.code,
    p.producto_id,
    p.lote_id,
    p.uv,
    p.uc,
    pr.nombre AS producto_nombre
  FROM wh_pallet p
  LEFT JOIN para_productos pr ON pr.id = p.producto_id
  WHERE p.pos_id = :pos AND p.deleted_at IS NULL
  ORDER BY p.id DESC
";
$st = $pdo->prepare($sql);
$st->execute([':pos' => $posId]);
$rows = $st->fetchAll(PDO::FETCH_ASSOC);

echo json_encode(['ok'=>true,'data'=>$rows], JSON_UNESCAPED_UNICODE);
