<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/db.php';

$posId = isset($_GET['pos_id']) ? (int)$_GET['pos_id'] : 0;
$DEBUG = isset($_GET['debug']) ? (int)$_GET['debug'] : 0;

if ($posId <= 0) {
  http_response_code(422);
  echo json_encode(['ok'=>false,'error'=>'pos_id requerido']); exit;
}

try {
  $pdo = getPDO();
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'db','debug'=>$DEBUG ? $e->getMessage() : null]); exit;
}

/**
 * Esquema real (según tu DESCRIBE):
 *   wh_pallet(id, codigo, deposito_id, cliente_id, posicion_id, estado_id, ..., deleted_at)
 *
 * Notas:
 * - Usamos posicion_id (no pos_id ni position_id).
 * - Devolvemos 'codigo' como 'code'.
 * - Filtramos por deleted_at IS NULL (si querés traer también borrados, quita ese filtro).
 */
$sql = "
  SELECT
    p.id,
    p.codigo      AS code,
    p.posicion_id AS pos_id
  FROM wh_pallet p
  WHERE p.posicion_id = :pos
    AND (p.deleted_at IS NULL)
  ORDER BY p.id ASC
";

try {
  $st = $pdo->prepare($sql);
  $st->execute([':pos' => $posId]);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  // Normalizamos la respuesta para el frontend actual:
  $out = [];
  foreach ($rows as $r) {
    $id   = (int)$r['id'];
    $code = (string)($r['code'] ?? ("PAL-$id"));
    $out[] = [
      'id'              => $id,
      'code'            => $code,
      'producto_id'     => null,      // tu esquema no tiene producto_id en wh_pallet
      'producto_nombre' => '',
      'color_hex'       => '',
      'lote_id'         => null,
      'uv'              => 0,
      'uc'              => 0,
      'pos_id'          => (int)$r['pos_id'],
    ];
  }

  $resp = ['ok'=>true,'data'=>$out];
  if ($DEBUG) {
    $resp['debug'] = [
      'sql'    => $sql,
      'params' => [':pos'=>$posId],
      'rows'   => count($out)
    ];
  }
  echo json_encode($resp, JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'query','debug'=>$DEBUG ? $e->getMessage() : null]);
}
