<?php
declare(strict_types=1);
// api/deposito/racks.php
// Lista única de racks por depósito a partir de wh_posicion

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2); // /api/deposito -> project root
require_once $ROOT . '/config/db.php';

try {
  $pdo = getPDO(); // <<< IMPORTANTE: inicializar PDO como en depositos.php
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error' => 'db', 'msg' => $e->getMessage()]);
  exit;
}

$depositoId = isset($_GET['deposito_id']) ? (int) $_GET['deposito_id'] : 0;
$ambienteId = isset($_GET['ambiente_id']) ? (int) $_GET['ambiente_id'] : 0;
if ($depositoId <= 0) {
  http_response_code(422);
  echo json_encode(['error' => 'param', 'msg' => 'deposito_id requerido']);
  exit;
}

// meta=select es opcional; lo aceptamos para consistencia
// $meta = $_GET['meta'] ?? 'select';

try {
  // racks únicos (activos y no borrados) del depósito
  $sql = "
SELECT
  wp.rack                             AS id,
  CONCAT('R', LPAD(wp.rack, 2, '0'))  AS code,
  CONCAT('Rack ', LPAD(wp.rack, 2, '0')) AS nombre
FROM wh_posicion wp
WHERE
  wp.deposito_id = :dep
  AND wp.activo = 1
  AND wp.deleted_at IS NULL
  " . ($ambienteId > 0 ? " AND wp.ambiente_id = :amb" : "") . "
GROUP BY wp.rack
ORDER BY wp.rack ASC
  ";
  $st = $pdo->prepare($sql);
  $params = [':dep' => $depositoId];
  if ($ambienteId > 0) $params[':amb'] = $ambienteId;
  $st->execute($params);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  // Devolvemos igual que depositos.php: array simple
  echo json_encode($rows, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error' => 'query', 'msg' => $e->getMessage()]);
}
