<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function hasColumn(PDO $pdo, string $t, string $c): bool {
  static $cache = [];
  $k = $t.'|'.$c;
  if (array_key_exists($k, $cache)) return $cache[$k];
  $stmt = $pdo->prepare("
    SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ?
  ");
  $stmt->execute([$t,$c]);
  $cache[$k] = ((int)$stmt->fetchColumn() > 0);
  return $cache[$k];
}

try {
  $pdo = get_pdo();
  $ingresoId = (int)($_GET['ingreso_id'] ?? 0);
  if ($ingresoId <= 0) {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>'ingreso_id requerido']);
    exit;
  }

  // Usar pl_rcv_link para obtener ítems relacionados con el ingreso
  // A través de pl_ingreso -> pl_packinglist -> pl_rcv_link
  // Usando wh_lote (singular) para obtener información del lote
  $sql = "
    SELECT
      p.codigo AS pallet_codigo,
      pr.sku,
      pr.denominacion,
      l.codigo AS lote,
      l.fecha_produccion,
      l.fecha_vencimiento,
      link.uv_cajas,
      0 AS uc_por_caja,
      link.uc_unidades AS uc_sueltas,
      link.uc_unidades AS uc_total
    FROM pl_ingreso ing
    JOIN pl_rcv_link link ON link.packinglist_id = ing.packinglist_id
    JOIN wh_pallet p ON p.id = link.pallet_id
    LEFT JOIN para_productos pr ON pr.id = link.producto_id
    LEFT JOIN wh_lote l ON l.id = link.lote_id
    WHERE ing.id = ?
      AND p.deleted_at IS NULL
    ORDER BY p.id, link.id
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$ingresoId]);

  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode(['ok'=>true,'data'=>$rows]);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false,'error'=>'Error listando ítems','msg'=>(env('APP_ENV')==='local')?$e->getMessage():'']);
}
