<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function hasColumn(PDO $pdo, string $table, string $col): bool {
    static $cache = [];
    $key = $table.'|'.$col;
    if (array_key_exists($key, $cache)) return $cache[$key];
    $stmt = $pdo->prepare("
        SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS
        WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = ?
    ");
    $stmt->execute([$table, $col]);
    $cache[$key] = ((int)$stmt->fetchColumn() > 0);
    return $cache[$key];
}

try {
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $ingresoId = (int)($_GET['ingreso_id'] ?? 0);
    if ($ingresoId <= 0) {
        http_response_code(400);
        echo json_encode(['ok'=>false, 'error'=>'ingreso_id requerido']);
        exit;
    }

    $posTable = 'wh_posicion';
    $displayExpr = null;
    if (hasColumn($pdo, $posTable, 'code')) {
        $displayExpr = "pos.code";
    } elseif (hasColumn($pdo, $posTable, 'pos_code')) {
        $displayExpr = "pos.pos_code";
    } elseif (hasColumn($pdo, $posTable, 'title')) {
        $displayExpr = "pos.title";
    } else {
        $displayExpr = "CONCAT('POS ', pos.id)";
    }

    $sql = "
      SELECT
        m.id,
        m.tipo,
        m.motivo,
        m.pallet_id,
        p.codigo AS pallet_codigo,
        COALESCE({$displayExpr}, 'Sin posición') AS posicion_desde,
        COALESCE(pos_to.code, pos_to.pos_code, pos_to.title, 'Sin posición') AS posicion_hacia,
        m.delta_uv,
        m.delta_uc,
        m.referencia,
        m.created_at
      FROM pl_ingreso ing
      JOIN pl_rcv_link link ON link.packinglist_id = ing.packinglist_id
      JOIN wh_move m ON m.pallet_id = link.pallet_id
      JOIN wh_pallet p ON p.id = m.pallet_id
      LEFT JOIN wh_posicion pos ON pos.id = m.from_pos_id
      LEFT JOIN wh_posicion pos_to ON pos_to.id = m.to_pos_id
      WHERE ing.id = ?
        AND m.deposito_id = ing.deposito_id
      ORDER BY m.created_at DESC, m.id DESC
    ";

    $stmt = $pdo->prepare($sql);
    $stmt->execute([$ingresoId]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['ok'=>true, 'data'=>$rows]);

} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok'=>false,
        'error'=>'Error listando movimientos',
        'msg'=>(env('APP_ENV')==='local') ? $e->getMessage() : ''
    ]);
}
