<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

// Raíz del proyecto (desde /api/operaciones → subir 2 niveles)
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/vendor/Editor/lib/DataTables.php';

use
  DataTables\Editor,
  DataTables\Editor\Field,
  DataTables\Editor\Options,
  DataTables\Editor\Validate,
  DataTables\Editor\ValidateOptions;

try {
  // Filtro por fecha (YYYY-MM-DD). Si no viene, usar hoy.
  $showAll = isset($_GET['all']) && ($_GET['all'] === '1' || strtolower((string)$_GET['all']) === 'true');
  $date = isset($_GET['date']) ? trim((string)$_GET['date']) : '';
  if (!$showAll) {
    if ($date === '' || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) {
      $date = date('Y-m-d');
    }
  }

  // Editor para oper_movil_disponible, con joins para labels
  $editor = Editor::inst($db, 'oper_movil_disponible', 'oper_movil_disponible.id')
    ->fields(
      Field::inst('oper_movil_disponible.id')->set(false),
      Field::inst('oper_movil_disponible.fecha')
        ->validator(Validate::notEmpty(ValidateOptions::inst()->message('La fecha es requerida.'))),
      Field::inst('oper_movil_disponible.movil_id')
        ->options(
          Options::inst()
            ->table('para_moviles')
            ->value('id')
            ->label('chapa')
            ->order('chapa asc')
        )
        ->validator(Validate::dbValues(ValidateOptions::inst()->message('Seleccione un móvil válido.'))),
      Field::inst('oper_movil_disponible.disponible')
        ->setFormatter(function($val, $data, $opts){
          return ($val === '1' || $val === 1 || $val === true) ? 1 : 0;
        }),
      Field::inst('oper_movil_disponible.ventana_ini'),
      Field::inst('oper_movil_disponible.ventana_fin'),
      Field::inst('oper_movil_disponible.llegada_time')
        ->setFormatter(function($val, $data, $opts){
          $v = is_string($val) ? trim($val) : $val;
          return ($v === '' || $v === null) ? null : $v;
        }),
      Field::inst('oper_movil_disponible.no_asistio')
        ->setFormatter(function($val, $data, $opts){
          return ($val === '1' || $val === 1 || $val === true) ? 1 : 0;
        }),
      Field::inst('oper_movil_disponible.no_utilizado')
        ->setFormatter(function($val, $data, $opts){
          return ($val === '1' || $val === 1 || $val === true) ? 1 : 0;
        }),
  Field::inst('oper_movil_disponible.notas'),

  // Auditoría de toggles (solo servidor)
  Field::inst('oper_movil_disponible.no_asistio_by')->set(false),
  Field::inst('oper_movil_disponible.no_asistio_at')->set(false),
  Field::inst('oper_movil_disponible.no_utilizado_by')->set(false),
  Field::inst('oper_movil_disponible.no_utilizado_at')->set(false),

      // Auditoría (solo lectura desde cliente)
      Field::inst('oper_movil_disponible.created_at')->set(false),
      Field::inst('oper_movil_disponible.updated_at')->set(false),

      // Labels de joins para mostrar en columnas
      Field::inst('para_moviles.chapa')->set(false),
      Field::inst('para_transportadoras.nombre')->set(false)
    )
    ->leftJoin('para_moviles', 'para_moviles.id', '=', 'oper_movil_disponible.movil_id')
    ->leftJoin('para_transportadoras', 'para_transportadoras.id', '=', 'para_moviles.transportadora_id');

  if (!$showAll) {
    $editor->where('oper_movil_disponible.fecha', $date);
  }
  $editor->debug(false)
    ->on('preEdit', function ($editor, $id, $values) use ($ROOT) {
      // Obtener usuario actual de sesión
      $uid = $_SESSION['usuario_id'] ?? null;
      $now = date('Y-m-d H:i:s');
      if (!isset($values['data']) || !is_array($values['data'])) return;
      $row = reset($values['data']);
      $m = isset($row['oper_movil_disponible']) && is_array($row['oper_movil_disponible']) ? $row['oper_movil_disponible'] : [];
      if (array_key_exists('no_asistio', $m)) {
        $v = $m['no_asistio'];
        $isYes = ($v === '1' || $v === 1 || $v === true);
        $editor->field('oper_movil_disponible.no_asistio_by')->setValue($isYes ? $uid : null);
        $editor->field('oper_movil_disponible.no_asistio_at')->setValue($isYes ? $now : null);
      }
      if (array_key_exists('no_utilizado', $m)) {
        $v = $m['no_utilizado'];
        $isYes = ($v === '1' || $v === 1 || $v === true);
        $editor->field('oper_movil_disponible.no_utilizado_by')->setValue($isYes ? $uid : null);
        $editor->field('oper_movil_disponible.no_utilizado_at')->setValue($isYes ? $now : null);
      }
  });

  $editor->process($_POST)->json();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'error'   => 'Error del servidor',
    'message' => $e->getMessage(),
  ], JSON_UNESCAPED_UNICODE);
}
