<?php
declare(strict_types=1);
/**
 * API: Disponibilidad de móviles por día
 * Entrada: GET date=YYYY-MM-DD (opcional; por defecto hoy)
 * Salida: { ok: true, data: { [movil_id]: { asignados:int, estados:string[], disponible:bool } } }
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $date = isset($_GET['date']) ? trim((string)$_GET['date']) : '';
  if ($date === '' || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) { $date = date('Y-m-d'); }

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  // Regla inicial (asumida): consideramos una asignación si hay un embarque con ese movil en ese día
  // Usamos COALESCE de fechas relevantes en orden: salida_at, carga_inicio_at, llegada_at
  // Nota: Esto puede ser ajustado más adelante según reglas del negocio.
  $sql = "
    SELECT e.movil_id,
           COALESCE(e.estado_id,0) AS estado_id,
           ee.code AS estado_code,
           DATE(COALESCE(e.salida_at, e.carga_inicio_at, e.llegada_at, e.created_at)) AS dia,
           COUNT(*) AS cant
      FROM so_embarque e
      LEFT JOIN so_embarque_estado ee ON ee.id = e.estado_id
     WHERE DATE(COALESCE(e.salida_at, e.carga_inicio_at, e.llegada_at, e.created_at)) = ?
     GROUP BY e.movil_id, estado_id, estado_code, dia
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$date]);

  $byMovil = [];
  while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
    $mid = (int)($row['movil_id'] ?? 0);
    if ($mid <= 0) continue;
    if (!isset($byMovil[$mid])) $byMovil[$mid] = ['asignados'=>0,'estados'=>[],'disponible'=>true];
    $byMovil[$mid]['asignados'] += (int)$row['cant'];
    $code = (string)($row['estado_code'] ?? '');
    if ($code !== '' && !in_array($code, $byMovil[$mid]['estados'], true)) $byMovil[$mid]['estados'][] = $code;
  }

  // Regla de disponibilidad: NO disponible si tiene al menos una asignación en estado no-finalizado
  // Ajustable: consideramos como no-finalizados: CREADO, PLANIFICADO, CARGANDO, CARGADO, EN_RUTA, ENTREGADO (hasta FINALIZADO queda libre)
  $notFree = ['CREADO','PLANIFICADO','CARGANDO','CARGADO','EN_RUTA','ENTREGADO'];
  foreach ($byMovil as $mid => &$info) {
    $info['disponible'] = !array_intersect($notFree, $info['estados']);
  }
  unset($info);

  out(['ok'=>true,'data'=>$byMovil,'date'=>$date]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'Error interno','message'=>$e->getMessage()], 500);
}
