<?php
declare(strict_types=1);

/**
 * API MOCK: Confirmar importación de Packing List (sin DB)
 * Ruta: api/operaciones/pl_confirm.php
 * Método: POST
 *
 * Propósito:
 * - Devuelve una respuesta JSON con datos de ejemplo para probar la UI
 * - No lee ni escribe base de datos / SP
 *
 * Contrato devuelto (compatible con tu front actual):
 * {
 *   ok: true,
 *   packinglist_id, packinglist_codigo, cliente_ref, fecha, overwrite,
 *   summary: {
 *      skus_importados, skus_nuevos,
 *      items_importados, lotes_importados, lotes_nuevos,
 *      cajas, uc_totales, uc_sueltas_est
 *   },
 *   hints: {
 *      pallets_count, positions_count,
 *      pallets_top: [{hint, c}, ...],
 *      positions_top: [{hint, c}, ...]
 *   },
 *   moves_columns: [], moves: [],  // (no generamos movimientos en esta etapa)
 *   message
 * }
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

// -------------------------------------------
// MOCKS configurables mínimos para probar UI
// -------------------------------------------
$today = date('Y-m-d');
$now   = date('Ymd-His');

// Puedes alternar entre dos escenarios simples cambiando $scenario:
$scenario = isset($_POST['scenario']) ? (string)$_POST['scenario'] : 'B';

/**
 * Escenario A (por defecto):
 * - 1 SKU, 1 ítem (sku+lote), 18 cajas, 540 UC
 * Escenario B:
 * - 2 SKUs, 3 ítems (sku+lote), 185 cajas, 5550 UC (simula tu Excel grande)
 */
if ($scenario === 'B') {
    $summary = [
        'skus_importados'  => 2,
        'skus_nuevos'      => 2,
        'items_importados' => 3,
        'lotes_importados' => 3,
        'lotes_nuevos'     => 3,
        'cajas'            => 185,
        'uc_totales'       => 5550,
        'uc_sueltas_est'   => 0,
    ];
    $hints = [
        'pallets_count'   => 13,
        'positions_count' => 0,
        'pallets_top'     => [
            ['hint' => 'P1', 'c' => 3],
            ['hint' => 'P2', 'c' => 3],
            ['hint' => 'P3', 'c' => 3],
            ['hint' => 'P4', 'c' => 2],
            ['hint' => 'P5', 'c' => 1],
            ['hint' => 'P6', 'c' => 1],
        ],
        'positions_top'   => [],
    ];
} else {
    // Escenario A (simple)
    $summary = [
        'skus_importados'  => 1,
        'skus_nuevos'      => 1,
        'items_importados' => 1,
        'lotes_importados' => 1,
        'lotes_nuevos'     => 1,
        'cajas'            => 18,
        'uc_totales'       => 540,
        'uc_sueltas_est'   => 0,
    ];
    $hints = [
        'pallets_count'   => 6,
        'positions_count' => 0,
        'pallets_top'     => [
            ['hint' => 'P1', 'c' => 1],
            ['hint' => 'P2', 'c' => 1],
            ['hint' => 'P3', 'c' => 1],
            ['hint' => 'P4', 'c' => 1],
            ['hint' => 'P5', 'c' => 1],
            ['hint' => 'P6', 'c' => 1],
        ],
        'positions_top'   => [],
    ];
}

// Metadatos básicos (mock)
$out = [
    'ok'                 => true,
    'packinglist_id'     => 123,                           // fijo para pruebas
    'packinglist_codigo' => 'PL-MOCK-' . $now,
    'cliente_ref'        => 'CLI-MOCK',
    'fecha'              => $today,
    'overwrite'          => 0,

    // Resumen para las cards
    'summary'            => $summary,

    // Sugerencias pallets/posiciones (línea inferior)
    'hints'              => $hints,

    // En esta etapa no hay movimientos reales
    'moves_columns'      => [],
    'moves'              => [],
    'columns'            => [],
    'data'               => [],

    'message'            => 'MOCK: Resumen de confirmación generado sin tocar DB. Usa POST scenario=B para alternar.'
];

echo json_encode($out, JSON_UNESCAPED_UNICODE);
