<?php
// api/operaciones/pl_diag_staging.php
declare(strict_types=1);

\header('Content-Type: application/json; charset=utf-8');
\error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
\ini_set('display_errors', '0');

$ROOT = \dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function jexit($payload, int $code = 200): void {
  \http_response_code($code);
  echo \json_encode($payload, JSON_UNESCAPED_UNICODE);
  exit;
}

try {
  $pdo = get_pdo();

  // DB activa
  $db = $pdo->query('SELECT DATABASE()')->fetchColumn();

  // Helper existencia de tabla
  $tableExists = function(string $tbl) use ($pdo) {
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM information_schema.tables WHERE table_schema = DATABASE() AND table_name = ?");
    $stmt->execute([$tbl]);
    return (int)$stmt->fetchColumn() > 0;
  };

  // Recolector de conteos / top5
  $inspect = function(string $tbl, array $cols = ['id']) use ($pdo, $tableExists) {
    if (!$tableExists($tbl)) return ['exists' => false];
    $count = (int)$pdo->query("SELECT COUNT(*) FROM `{$tbl}`")->fetchColumn();
    $colsSel = implode(',', array_map(fn($c)=>"`{$c}`", $cols));
    $top = [];
    try {
      $top = $pdo->query("SELECT {$colsSel} FROM `{$tbl}` ORDER BY 1 DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
    } catch (\Throwable $e) {
      // si columnas no existen, devolvemos id/created genérico
      try {
        $top = $pdo->query("SELECT * FROM `{$tbl}` ORDER BY 1 DESC LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);
      } catch (\Throwable $e2) { $top = []; }
    }
    return ['exists' => true, 'count' => $count, 'top' => $top];
  };

  $out = [
    'ok'       => true,
    'database' => $db,
    'singular' => [
      'pl_import_batch' => $inspect('pl_import_batch', ['id','tipo','filename','imported_at','rows_total','rows_ok','rows_error']),
      'pl_import_row'   => $inspect('pl_import_row',   ['id','batch_id','rownum','status']),
    ],
    'plural'   => [
      'pl_import_batches' => $inspect('pl_import_batches', ['id','archivo_nombre','created_at','rows_ok','rows_error']),
      'pl_import_rows'    => $inspect('pl_import_rows',    ['id','batch_id','fila_nro','sku','denominacion']),
    ],
  ];

  jexit($out);
} catch (\Throwable $e) {
  jexit(['ok' => false, 'error' => 'diag failed: '.$e->getMessage()], 500);
}
