<?php
declare(strict_types=1);

/**
 * API: Confirmar preparación de un pedido
 * Entrada: POST so_id | so_codigo
 * Lógica:
 *  - Calcula por cada item expected vs prepared.
 *  - Si todos los items tienen prepared >= expected (por UV/UC), estado → PREPARADO.
 *  - Si alguno quedó pendiente (>0), estado → PARCIAL.
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out_c(array $p, int $c = 200): void { http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); exit; }

try {
    if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') out_c(['ok'=>false,'error'=>'Método no permitido'], 405);

    $raw = file_get_contents('php://input');
    $isJson = isset($_SERVER['CONTENT_TYPE']) && stripos((string)$_SERVER['CONTENT_TYPE'], 'application/json') !== false;
    $payload = $isJson && $raw ? (json_decode($raw, true) ?: []) : [];
    $payload = array_merge($_POST, $payload);

    $soId = isset($payload['so_id']) ? (int)$payload['so_id'] : 0;
    $soCodigo = isset($payload['so_codigo']) ? trim((string)$payload['so_codigo']) : '';

    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec('SET NAMES utf8mb4');

    if ($soId <= 0 && $soCodigo !== '') {
        $st = $pdo->prepare('SELECT id FROM so_pedido WHERE codigo=? LIMIT 1');
        $st->execute([$soCodigo]);
        $soId = (int)$st->fetchColumn();
    }
    if ($soId <= 0) out_c(['ok'=>false,'error'=>'Debe indicar so_id o so_codigo'], 422);

    // Resumen de pendientes
    $sql = 'SELECT SUM(GREATEST(i.expected_uv - i.prepared_uv,0)) AS pend_uv,
                   SUM(GREATEST(i.expected_uc - i.prepared_uc,0)) AS pend_uc
              FROM so_pedido_dest d
              JOIN so_pedido_dest_item i ON i.pedido_dest_id = d.id
             WHERE d.pedido_id = ?';
    $st = $pdo->prepare($sql);
    $st->execute([$soId]);
    $row = $st->fetch(PDO::FETCH_ASSOC) ?: ['pend_uv'=>0,'pend_uc'=>0];
    $pendUv = (int)$row['pend_uv'];
    $pendUc = (int)$row['pend_uc'];

    // Estado destino
    $estado = ($pendUv === 0 && $pendUc === 0) ? 'PREPARADO' : 'PARCIAL';

    $stE = $pdo->prepare('SELECT id FROM so_pedido_estado WHERE code=? LIMIT 1');
    $stE->execute([$estado]);
    $estadoId = (int)$stE->fetchColumn();
    if ($estadoId <= 0) out_c(['ok'=>false,'error'=>"Estado destino no existe: $estado"], 500);

    $stU = $pdo->prepare('UPDATE so_pedido SET estado_id=? WHERE id=?');
    $stU->execute([$estadoId, $soId]);

    out_c(['ok'=>true, 'so_id'=>$soId, 'estado'=>$estado, 'pendientes'=>['uv'=>$pendUv,'uc'=>$pendUc]]);
} catch (Throwable $e) {
    out_c(['ok'=>false,'error'=>'No se pudo confirmar la preparación','message'=>$e->getMessage()], 500);
}
