<?php
declare(strict_types=1);

/**
 * API: Confirmar reposición completada
 * Cambia el estado del pedido de REPOSICION a EN_PREPARACION
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function respond(array $d, int $c = 200): void { 
    http_response_code($c); 
    echo json_encode($d, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); 
    exit; 
}

try {
    if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') {
        respond(['ok' => false, 'error' => 'Only POST method allowed'], 405);
    }

    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec('SET NAMES utf8mb4');

    // Read JSON payload
    $raw = file_get_contents('php://input');
    $isJson = isset($_SERVER['CONTENT_TYPE']) && stripos((string)$_SERVER['CONTENT_TYPE'], 'application/json') !== false;
    $payload = $isJson && $raw ? (json_decode($raw, true) ?: []) : [];
    $payload = array_merge($_POST, $payload);

    $soId = isset($payload['so_id']) ? (int)$payload['so_id'] : 0;
    if ($soId <= 0) {
        respond(['ok' => false, 'error' => 'so_id requerido'], 400);
    }

    // Verificar que el pedido existe y está en estado REPOSICION
    $stmt = $pdo->prepare("
        SELECT p.id, p.codigo, pe.code as estado_code 
        FROM so_pedido p 
        LEFT JOIN so_pedido_estado pe ON pe.id = p.estado_id 
        WHERE p.id = ?
    ");
    $stmt->execute([$soId]);
    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$pedido) {
        respond(['ok' => false, 'error' => 'Pedido no encontrado'], 404);
    }

    if ($pedido['estado_code'] !== 'REPOSICION') {
        respond(['ok' => false, 'error' => 'El pedido no está en estado de reposición'], 400);
    }

    // Obtener ID del estado EN_PREPARACION
    $stmt = $pdo->prepare("SELECT id FROM so_pedido_estado WHERE code = 'EN_PREPARACION'");
    $stmt->execute();
    $estadoPreparacionId = $stmt->fetchColumn();

    if (!$estadoPreparacionId) {
        respond(['ok' => false, 'error' => 'Estado EN_PREPARACION no encontrado'], 500);
    }

    // Actualizar estado del pedido
    $stmt = $pdo->prepare("UPDATE so_pedido SET estado_id = ? WHERE id = ?");
    $stmt->execute([$estadoPreparacionId, $soId]);

    respond([
        'ok' => true, 
        'message' => 'Reposición confirmada',
        'pedido' => [
            'id' => $pedido['id'],
            'codigo' => $pedido['codigo'],
            'estado_anterior' => 'REPOSICION',
            'estado_nuevo' => 'EN_PREPARACION'
        ]
    ]);

} catch (Throwable $e) {
    respond(['ok' => false, 'error' => 'Error interno', 'message' => $e->getMessage()], 500);
}
?>