<?php
declare(strict_types=1);
/**
 * API: Adjuntar un PRE a un Embarque
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') out(['ok'=>false,'error'=>'Método no permitido'], 405);
  $raw = file_get_contents('php://input') ?: '';
  $body = json_decode($raw, true);
  if (!is_array($body)) $body = $_POST;
  $embId = isset($body['embarque_id']) ? (int)$body['embarque_id'] : 0;
  $preId = isset($body['pre_id']) ? (int)$body['pre_id'] : 0;
  if ($embId<=0 || $preId<=0) out(['ok'=>false,'error'=>'embarque_id y pre_id requeridos'], 422);

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  // Validar que el PRE esté COMPLETADO
  $stPre = $pdo->prepare("SELECT est.code AS estado
                            FROM so_preembarque p
                            JOIN so_preembarque_estado est ON est.id=p.estado_id
                           WHERE p.id=? LIMIT 1");
  $stPre->execute([$preId]);
  $preEst = strtoupper((string)($stPre->fetchColumn() ?: ''));
  if ($preEst !== 'COMPLETADO') {
    out(['ok'=>false,'error'=>'El PRE debe estar COMPLETADO para adjuntar (actual: ' . ($preEst ?: 'N/A') . ')'], 422);
  }

  // simple exists
  $chk = $pdo->prepare('SELECT COUNT(*) FROM so_embarque_pre WHERE embarque_id=? AND preembarque_id=?');
  $chk->execute([$embId,$preId]);
  if ((int)$chk->fetchColumn() > 0) out(['ok'=>true,'attached'=>false,'reason'=>'ya_existe']);

  $ins = $pdo->prepare('INSERT INTO so_embarque_pre (embarque_id, preembarque_id) VALUES (?,?)');
  $ins->execute([$embId,$preId]);

  out(['ok'=>true,'attached'=>true]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'No se pudo adjuntar','message'=>$e->getMessage()], 500);
}
