<?php
declare(strict_types=1);
/**
 * API: Crear un nuevo Embarque (EN_COLA) y devolver su ID/código
 * Opcionalmente acepta deposito_id; si falta, intenta inferir por el PRE o por el usuario.
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') out(['ok'=>false,'error'=>'Método no permitido'], 405);
  $raw = file_get_contents('php://input') ?: '';
  $body = json_decode($raw, true);
  if (!is_array($body)) $body = $_POST;

  $depositoId = isset($body['deposito_id']) ? (int)$body['deposito_id'] : 0;
  $preId = isset($body['pre_id']) ? (int)$body['pre_id'] : 0;

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  if ($depositoId <= 0 && $preId > 0) {
    $st = $pdo->prepare('SELECT deposito_id FROM so_preembarque WHERE id=?');
    $st->execute([$preId]);
    $depositoId = (int)$st->fetchColumn();
  }
  if ($depositoId <= 0) out(['ok'=>false,'error'=>'deposito_id requerido (o provea pre_id)'], 422);

  // Estado EN_COLA
  $estId = (int)$pdo->query("SELECT id FROM so_embarque_estado WHERE code='EN_COLA' LIMIT 1")->fetchColumn();
  if ($estId<=0) out(['ok'=>false,'error'=>'Catálogo de estados incompleto (EN_COLA)'], 500);

  // Generar código secuencial simple EMB-YYYYMM-XXXX
  $prefix = 'EMB-' . date('Ym') . '-';
  $st = $pdo->prepare("SELECT MAX(CAST(SUBSTRING(codigo, 12) AS UNSIGNED)) FROM so_embarque WHERE codigo LIKE ?");
  $st->execute([$prefix.'%']);
  $n = (int)$st->fetchColumn(); $n = $n + 1; $codigo = $prefix . str_pad((string)$n, 4, '0', STR_PAD_LEFT);

  $ins = $pdo->prepare('INSERT INTO so_embarque (codigo, deposito_id, estado_id) VALUES (?,?,?)');
  $ins->execute([$codigo, $depositoId, $estId]);
  $id = (int)$pdo->lastInsertId();

  // Adjuntar PRE si vino
  if ($preId>0) {
    $pdo->prepare('INSERT IGNORE INTO so_embarque_pre(embarque_id, preembarque_id) VALUES (?,?)')->execute([$id,$preId]);
  }

  out(['ok'=>true,'embarque_id'=>$id,'codigo'=>$codigo]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'No se pudo crear embarque','message'=>$e->getMessage()], 500);
}
