<?php
declare(strict_types=1);
/**
 * API: Desvincular un PRE de un Embarque
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') out(['ok'=>false,'error'=>'Método no permitido'], 405);
  $raw = file_get_contents('php://input') ?: '';
  $body = json_decode($raw, true);
  if (!is_array($body)) $body = $_POST;
  $embId = isset($body['embarque_id']) ? (int)$body['embarque_id'] : 0;
  $preId = isset($body['pre_id']) ? (int)$body['pre_id'] : 0;
  if ($embId<=0 || $preId<=0) out(['ok'=>false,'error'=>'embarque_id y pre_id requeridos'], 422);

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $del = $pdo->prepare('DELETE FROM so_embarque_pre WHERE embarque_id=? AND preembarque_id=?');
  $del->execute([$embId,$preId]);

  out(['ok'=>true,'detached'=>($del->rowCount()>0)]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'No se pudo quitar','message'=>$e->getMessage()], 500);
}
