<?php
declare(strict_types=1);
/**
 * API: Obtener detalle de Embarque
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $id = isset($_GET['embarque_id']) ? (int)$_GET['embarque_id'] : 0;
  if ($id<=0) out(['ok'=>false,'error'=>'embarque_id requerido'], 422);

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $st = $pdo->prepare("SELECT e.*, ee.code AS estado, ee.orden AS estado_orden, d.code AS deposito_code,
            mv.chapa AS movil_label,
            ch.nombre AS chofer_label
          FROM so_embarque e
          JOIN so_embarque_estado ee ON ee.id=e.estado_id
          JOIN wh_deposito d ON d.id=e.deposito_id
        LEFT JOIN para_moviles mv ON mv.id = e.movil_id
        LEFT JOIN para_choferes ch ON ch.id = e.chofer_id
            WHERE e.id=? LIMIT 1");
  $st->execute([$id]);
  $e = $st->fetch(PDO::FETCH_ASSOC);
  if (!$e) out(['ok'=>false,'error'=>'No existe el embarque'], 404);

  $stp = $pdo->prepare("SELECT pre.id, pre.codigo, CONCAT('SO-', pre.pedido_id) AS pedido, est.code AS estado
                          FROM so_embarque_pre ep
                          JOIN so_preembarque pre ON pre.id=ep.preembarque_id
                          LEFT JOIN so_preembarque_estado est ON est.id=pre.estado_id
                         WHERE ep.embarque_id=?");
  $stp->execute([$id]);
  $pres = $stp->fetchAll(PDO::FETCH_ASSOC) ?: [];

  // Retorno (si existe)
  $str = $pdo->prepare("SELECT r.id, r.llegada_at, r.observacion FROM so_retorno r WHERE r.embarque_id=? ORDER BY r.created_at DESC LIMIT 1");
  $str->execute([$id]);
  $ret = $str->fetch(PDO::FETCH_ASSOC) ?: null;

  $estadoOrden = isset($e['estado_orden']) ? (int)$e['estado_orden'] : 0;
  $prevCode = null;
  if ($estadoOrden > 0) {
    $stPrev = $pdo->prepare("SELECT code FROM so_embarque_estado WHERE orden < ? AND activo = 1 ORDER BY orden DESC LIMIT 1");
    $stPrev->execute([$estadoOrden]);
    $prevCode = $stPrev->fetchColumn();
    if ($prevCode !== false) {
      $prevCode = strtoupper((string)$prevCode);
    } else {
      $prevCode = null;
    }
  }

  out([
    'ok'=>true,
    'embarque'=>[
      'id'=>(int)$e['id'],
      'codigo'=>(string)$e['codigo'],
      'deposito'=>(string)$e['deposito_code'],
      'estado'=>(string)$e['estado'],
      'estado_orden'=>$estadoOrden,
      'prev_estado_code'=>$prevCode,
      'movil_id'=>$e['movil_id']!==null?(int)$e['movil_id']:null,
  'movil_label'=>isset($e['movil_label']) ? (string)$e['movil_label'] : null,
      'chofer_id'=>$e['chofer_id']!==null?(int)$e['chofer_id']:null,
  'chofer_label'=>isset($e['chofer_label']) ? (string)$e['chofer_label'] : null,
      'llegada_at'=>$e['llegada_at'],
      'carga_inicio_at'=>$e['carga_inicio_at'],
      'carga_fin_at'=>$e['carga_fin_at'],
      'salida_at'=>$e['salida_at'],
      'ticket_porteria'=>$e['ticket_porteria'],
      'ticket_bascula'=>$e['ticket_bascula'],
      'temp_salida_c'=>$e['temp_salida_c'],
      'ayudantes_cant'=>$e['ayudantes_cant'],
      'km_inicial'=>$e['km_inicial'],
      'observacion'=>$e['observacion'],
    ],
    'preembarques'=>$pres,
    'retorno'=>$ret,
  ]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'Error interno','message'=>$e->getMessage()], 500);
}
