<?php
declare(strict_types=1);
/**
 * API: Listado de Embarques
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE); exit; }

try {
  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $sql = "SELECT e.id, e.codigo, ee.code AS estado, e.creado_at
            , (SELECT COUNT(*) FROM so_embarque_pre ep WHERE ep.embarque_id=e.id) AS pre_count
            , (SELECT COUNT(*) FROM so_embarque_parada pa WHERE pa.embarque_id=e.id) AS paradas
          FROM so_embarque e
          LEFT JOIN so_embarque_estado ee ON ee.id = e.estado_id
          ORDER BY e.creado_at DESC, e.id DESC
          LIMIT 500";
  $rows = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC) ?: [];
  $data = array_map(function($r){
    return [
      'embarque' => [
        'id' => (int)$r['id'],
        'codigo' => (string)$r['codigo'],
        'estado' => (string)$r['estado'],
        'creado_at' => (string)$r['creado_at'],
      ],
      'kpi' => [ 'pre_count'=>(int)$r['pre_count'], 'paradas'=>(int)$r['paradas'] ],
    ];
  }, $rows);

  out(['data'=>$data]);
} catch (Throwable $e) {
  out(['error'=>'No se pudo listar embarques','message'=>$e->getMessage()], 500);
}
