<?php
declare(strict_types=1);
/**
 * API: Cambiar estado del Embarque por code
 * POST: { embarque_id: number, estado_code: string }
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';
require_once $ROOT . '/app/Support/ApiHelpers.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') out(['ok'=>false,'error'=>'Método no permitido'], 405);
  $raw = file_get_contents('php://input') ?: '';
  $body = json_decode($raw, true);
  if (!is_array($body)) $body = $_POST;

  $id = isset($body['embarque_id']) ? (int)$body['embarque_id'] : 0;
  $code = isset($body['estado_code']) ? strtoupper(trim((string)$body['estado_code'])) : '';
  if ($id<=0 || $code==='') out(['ok'=>false,'error'=>'embarque_id y estado_code requeridos'], 422);

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');
  $pdo->beginTransaction();

  // No permitir cambios si ya está FINALIZADO
  $stCur = $pdo->prepare("SELECT ee.code, e.movil_id
                            FROM so_embarque e
                            JOIN so_embarque_estado ee ON ee.id = e.estado_id
                           WHERE e.id = ?
                           LIMIT 1
                           FOR UPDATE");
  $stCur->execute([$id]);
  $curRow = $stCur->fetch(PDO::FETCH_ASSOC);
  $curCode = strtoupper((string)($curRow['code'] ?? ''));
  $movilId = isset($curRow['movil_id']) && $curRow['movil_id'] !== null ? (int)$curRow['movil_id'] : null;
  $hasOcupadoColumn = columnExists($pdo, 'para_moviles', 'ocupado');
  if ($curCode === 'FINALIZADO') {
    $pdo->rollBack();
    out(['ok'=>false,'error'=>'Embarque finalizado: no admite cambio de estado'], 409);
  }

  // Validar que el estado exista
  $st = $pdo->prepare("SELECT id, code FROM so_embarque_estado WHERE code=? LIMIT 1");
  $st->execute([$code]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if (!$row) out(['ok'=>false,'error'=>'Estado inválido'], 422);
  $estadoId = (int)$row['id'];

  // Cambiar estado
  $st = $pdo->prepare("UPDATE so_embarque SET estado_id=? WHERE id=?");
  $st->execute([$estadoId, $id]);

  if ($hasOcupadoColumn && $movilId && in_array($code, ['VUELTA','FINALIZADO'], true)) {
    $upd = $pdo->prepare('UPDATE para_moviles SET ocupado = 0, updated_at = NOW() WHERE id = ?');
    $upd->execute([$movilId]);
  }

  $pdo->commit();

  out(['ok'=>true, 'estado_code'=>$code]);
} catch (Throwable $e) {
  if (isset($pdo) && $pdo->inTransaction()) {
    $pdo->rollBack();
  }
  out(['ok'=>false,'error'=>'No se pudo cambiar el estado','message'=>$e->getMessage()], 500);
}
