<?php
declare(strict_types=1);
/**
 * API: Seguimiento - Destinos por Embarque
 * Devuelve una fila por destinatario asociado a los PREs del embarque,
 * con facturas/documentos (best-effort) y totales UV/UC para referencia.
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';
require_once $ROOT . '/app/Support/EmbarqueDocs.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $embarqueId = isset($_GET['embarque_id']) ? (int)$_GET['embarque_id'] : 0;
  if ($embarqueId <= 0) out(['ok'=>false,'error'=>'embarque_id requerido'], 422);

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $context = embarque_collect_destinatarios_docs($pdo, $embarqueId);
  $byDest = $context['destinatarios'] ?? [];
  $docsByPedidoDest = $context['pedido_docs'] ?? [];

  // Merge con seguimiento guardado (si existe)
  $segByDest = [];
  if (!empty($byDest)) {
    $place = implode(',', array_fill(0, count(array_keys($byDest)), '?'));
    $sql = "SELECT * FROM so_embarque_seguimiento_dest WHERE embarque_id=? AND destinatario_id IN ($place)";
    $params = array_merge([$embarqueId], array_keys($byDest));
    try {
      $stSeg = $pdo->prepare($sql);
      $stSeg->execute($params);
      while ($row = $stSeg->fetch(PDO::FETCH_ASSOC)) { $segByDest[(int)$row['destinatario_id']] = $row; }
    } catch (Throwable $e) { /* tabla podría no existir aún hasta migrar */ }
  }

  // Armar salida
  $data = [];
  foreach ($byDest as $dId => $agg) {
    $pids = array_keys($agg['pedido_dest_ids']);
    $docs = [];
    foreach ($pids as $pid) {
      if (isset($docsByPedidoDest[$pid])) {
        foreach ($docsByPedidoDest[$pid] as $entry) {
          $label = trim((string)($entry['label'] ?? ''));
          if ($label !== '') {
            $docs[] = $label;
          }
        }
      }
    }
    $uniqueDocs = array_values(array_unique($docs));
    $docTxt = implode(' | ', $uniqueDocs);

    $seg = $segByDest[$dId] ?? [];
    $data[] = [
      'destinatario_id' => $agg['destinatario_id'] ?? $dId,
      'cliente_final'   => $agg['destinatario'],
      'facturas'        => $docTxt,
      'facturas_list'   => $uniqueDocs,
      'uv'              => (int)$agg['uv'],
      'uc'              => (int)$agg['uc'],
      // Campos de seguimiento (placeholders inicialmente vacíos)
      'inicio_carga' => $seg['inicio_carga'] ?? null,
      'fin_carga'    => $seg['fin_carga'] ?? null,
      'km_inicial'   => isset($seg['km_inicial']) ? (int)$seg['km_inicial'] : null,
      'km_llegada'   => isset($seg['km_llegada']) ? (int)$seg['km_llegada'] : null,
      'hr_llegada'   => $seg['hr_llegada'] ?? null,
      'hr_inicio'    => $seg['hr_inicio'] ?? null,
      'espera_desc'  => $seg['espera_descargar'] ?? null,
      'hr_termino'   => $seg['hr_termino'] ?? null,
      'tiempo_desc'  => $seg['tiempo_descarga'] ?? null,
      'hr_salida'    => $seg['hr_salida'] ?? null,
      'tiempo_ctrl'  => $seg['tiempo_control'] ?? null,
      'tiempo_total' => $seg['tiempo_total'] ?? null,
      'tipo_carga'   => $seg['tipo_carga'] ?? null,
      'salida_camara'=> $seg['salida_camara'] ?? null,
      'temp_carga_c' => isset($seg['temp_carga_c']) ? (float)$seg['temp_carga_c'] : null,
      'temp_desc_c'  => isset($seg['temp_desc_c']) ? (float)$seg['temp_desc_c'] : null,
      'aviso_quien'  => $seg['aviso_quien'] ?? null,
      'aviso_hora'   => $seg['aviso_hora'] ?? null,
      'problema'     => $seg['problema'] ?? null,
    ];
  }

  out(['ok'=>true,'data'=>$data]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'Error interno','message'=>$e->getMessage()], 500);
}
