<?php
declare(strict_types=1);
/**
 * API: Guardar seguimiento por destinatario
 * Acepta JSON con { embarque_id, destinatario_id, field, value } o { embarque_id, destinatario_id, data: {campo:valor,...} }
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $raw = file_get_contents('php://input');
  $body = json_decode($raw ?: '[]', true) ?: [];
  $embarqueId = isset($body['embarque_id']) ? (int)$body['embarque_id'] : 0;
  $destId = isset($body['destinatario_id']) ? (int)$body['destinatario_id'] : 0;
  if ($embarqueId<=0 || $destId<=0) out(['ok'=>false,'error'=>'embarque_id y destinatario_id requeridos'], 422);

  $allowed = [
    'inicio_carga'=>'inicio_carga', 'fin_carga'=>'fin_carga',
    'km_inicial'=>'km_inicial', 'km_llegada'=>'km_llegada',
    'hr_llegada'=>'hr_llegada', 'hr_inicio'=>'hr_inicio',
    'espera_desc'=>'espera_descargar', 'hr_termino'=>'hr_termino',
    'tiempo_desc'=>'tiempo_descarga', 'hr_salida'=>'hr_salida',
    'tiempo_ctrl'=>'tiempo_control', 'tiempo_total'=>'tiempo_total',
    'tipo_carga'=>'tipo_carga', 'salida_camara'=>'salida_camara',
    'temp_carga_c'=>'temp_carga_c', 'temp_desc_c'=>'temp_desc_c',
    'aviso_quien'=>'aviso_quien', 'aviso_hora'=>'aviso_hora',
    'problema'=>'problema',
  ];

  $data = [];
  if (isset($body['field'])) {
    $fld = (string)$body['field'];
    if (!isset($allowed[$fld])) out(['ok'=>false,'error'=>'Campo no permitido'], 422);
    $data[$allowed[$fld]] = $body['value'] ?? null;
  } elseif (isset($body['data']) && is_array($body['data'])) {
    foreach ($body['data'] as $k=>$v) {
      if (isset($allowed[$k])) $data[$allowed[$k]] = $v;
    }
  }
  if (empty($data)) out(['ok'=>false,'error'=>'Sin datos para guardar'], 422);

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  // Build UPSERT
  $cols = array_keys($data);
  $placeholders = implode(',', array_fill(0, count($cols), '?'));
  $updates = implode(',', array_map(function($c){ return "$c=VALUES($c)"; }, $cols));

  $sql = 'INSERT INTO so_embarque_seguimiento_dest (embarque_id, destinatario_id, '.implode(',', $cols).')'
       . ' VALUES (?, ?, '.$placeholders.') ON DUPLICATE KEY UPDATE '.$updates;

  $params = array_merge([$embarqueId, $destId], array_values($data));
  $st = $pdo->prepare($sql);
  $st->execute($params);

  out(['ok'=>true]);
} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'Error interno','message'=>$e->getMessage()], 500);
}
