<?php
declare(strict_types=1);

/**
 * API: Get current state of a sales order
 * Returns the current estado information for a pedido
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out_estado(array $p, int $c = 200): void { 
    http_response_code($c); 
    echo json_encode($p, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); 
    exit; 
}

try {
    if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'GET') {
        out_estado(['ok'=>false,'error'=>'Only GET method allowed'], 405);
    }

    $soId = isset($_GET['so_id']) ? (int)$_GET['so_id'] : 0;
    $soCodigo = isset($_GET['so_codigo']) ? trim((string)$_GET['so_codigo']) : '';

    if ($soId <= 0 && $soCodigo === '') {
        out_estado(['ok'=>false,'error'=>'so_id or so_codigo required'], 422);
    }

    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Get pedido with estado info
    if ($soId > 0) {
        $stmt = $pdo->prepare('
            SELECT p.id, p.codigo, p.estado_id, e.code, e.nombre 
            FROM so_pedido p 
            LEFT JOIN so_pedido_estado e ON e.id = p.estado_id 
            WHERE p.id = ? LIMIT 1
        ');
        $stmt->execute([$soId]);
    } else {
        $stmt = $pdo->prepare('
            SELECT p.id, p.codigo, p.estado_id, e.code, e.nombre 
            FROM so_pedido p 
            LEFT JOIN so_pedido_estado e ON e.id = p.estado_id 
            WHERE p.codigo = ? LIMIT 1
        ');
        $stmt->execute([$soCodigo]);
    }

    $pedido = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$pedido) {
        out_estado(['ok'=>false,'error'=>'Pedido not found'], 404);
    }

    out_estado([
        'ok' => true,
        'pedido' => [
            'id' => (int)$pedido['id'],
            'codigo' => $pedido['codigo']
        ],
        'estado' => [
            'id' => (int)$pedido['estado_id'],
            'code' => $pedido['code'],
            'nombre' => $pedido['nombre']
        ]
    ]);

} catch (Throwable $e) {
    out_estado([
        'ok'=>false,
        'error'=>'Could not get pedido estado',
        'message'=>$e->getMessage()
    ], 500);
}
?>