<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

require_once dirname(__DIR__, 2) . '/config/db.php';

function out_json($p, int $code=200){ http_response_code($code); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $pdo = getPDO();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Throwable $e) {
  out_json(['ok'=>false,'error'=>'DB error'], 500);
}

$soId = isset($_REQUEST['so_id']) ? (int)$_REQUEST['so_id'] : 0;
$soCode = isset($_REQUEST['codigo']) ? trim((string)$_REQUEST['codigo']) : '';
if ($soId<=0 && $soCode==='') out_json(['ok'=>false,'error'=>'so_id o codigo requerido'], 422);

try {
  // Detect if so_pedido has deposito_id
  $hasDepo = false;
  try {
    $chk = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='so_pedido' AND COLUMN_NAME='deposito_id'");
    $chk->execute();
    $hasDepo = ((int)$chk->fetchColumn() > 0);
  } catch (Throwable $e2) { $hasDepo = false; }

  if ($hasDepo) {
    $sql = "SELECT sp.id, sp.codigo, sp.estado_id, se.code AS estado_code, se.nombre AS estado_nombre, sp.deposito_id, d.codigo AS deposito_code, d.nombre AS deposito_nombre, sp.created_at, sp.updated_at FROM so_pedido sp LEFT JOIN so_pedido_estado se ON se.id = sp.estado_id LEFT JOIN wh_deposito d ON d.id = sp.deposito_id WHERE ";
  } else {
    $sql = "SELECT sp.id, sp.codigo, sp.estado_id, se.code AS estado_code, se.nombre AS estado_nombre, NULL AS deposito_id, NULL AS deposito_code, NULL AS deposito_nombre, sp.created_at, sp.updated_at FROM so_pedido sp LEFT JOIN so_pedido_estado se ON se.id = sp.estado_id WHERE ";
  }
  $params = [];
  if ($soId>0) { $sql .= 'sp.id=?'; $params[] = $soId; }
  else { $sql .= 'sp.codigo=?'; $params[] = $soCode; }
  $sql .= ' LIMIT 1';
  $st = $pdo->prepare($sql);
  $st->execute($params);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if (!$row) out_json(['ok'=>false,'error'=>'Pedido no encontrado'], 404);
  out_json(['ok'=>true,'pedido'=>$row]);
} catch (Throwable $e) {
  out_json(['ok'=>false,'error'=>'Error consultando pedido','message'=>$e->getMessage()], 500);
}

?>
