<?php
declare(strict_types=1);

/**
 * API: Obtener información del PRE (preembarque) de un pedido
 * Método: GET
 * Parámetros: pre_id (opcional), so_id (opcional)
 * Respuesta:
 *   { ok: true, pre: { id, codigo, pedido_id }, has_preembarque: bool }
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';
require_once $ROOT . '/app/Support/SoPreparacionReport.php';

function out_json(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $preId = isset($_GET['pre_id']) ? (int)$_GET['pre_id'] : 0;
  $soId  = isset($_GET['so_id']) ? (int)$_GET['so_id']  : 0;

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $pre = null;
  if ($preId > 0) {
    $st = $pdo->prepare('SELECT id, codigo, pedido_id FROM so_preembarque WHERE id=? LIMIT 1');
    $st->execute([$preId]);
    $pre = $st->fetch(PDO::FETCH_ASSOC) ?: null;
  } elseif ($soId > 0) {
    // Buscar por código PRE-{so_codigo}
    $stS = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
    $stS->execute([$soId]);
    $soCodigo = $stS->fetchColumn();
    if ($soCodigo) {
      $preCode = 'PRE-' . $soCodigo;
      $st = $pdo->prepare('SELECT id, codigo, pedido_id FROM so_preembarque WHERE codigo=? LIMIT 1');
      $st->execute([$preCode]);
      $pre = $st->fetch(PDO::FETCH_ASSOC) ?: null;
    }
  }

  $dataset = so_pre_fetch_dataset($pdo, [
    'pre_id' => $preId,
    'so_id'  => $soId,
  ]);

  if (!$dataset['pre']) {
    out_json(['ok'=>true,'has_preembarque'=>false]);
  }

  out_json([
    'ok' => true,
    'has_preembarque' => true,
    'pre' => $dataset['pre'],
    'pedido' => $dataset['pedido'],
    'data' => $dataset['rows'],
    'totals' => $dataset['totals'],
  ]);

} catch (Throwable $e) {
  out_json(['ok'=>false,'error'=>'Error obteniendo PRE','message'=>$e->getMessage()], 500);
}
