<?php
declare(strict_types=1);

/**
 * API: Datos del documento de picking (pre-embarque)
 * Entrada: GET pre_id | pre_codigo | so_id | so_codigo
 * Salida: header del pre, items por posición/lote (orden FEFO), totales.
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out_doc(array $p, int $c = 200): void { http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES); exit; }

try {
    if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'GET') out_doc(['ok'=>false,'error'=>'Método no permitido'], 405);

    $preId     = isset($_GET['pre_id']) ? (int)$_GET['pre_id'] : 0;
    $preCodigo = isset($_GET['pre_codigo']) ? trim((string)$_GET['pre_codigo']) : '';
    $soId      = isset($_GET['so_id']) ? (int)$_GET['so_id'] : 0;
    $soCodigo  = isset($_GET['so_codigo']) ? trim((string)$_GET['so_codigo']) : '';

    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec('SET NAMES utf8mb4');

    if ($preId <= 0 && $preCodigo === '' && $soId <= 0 && $soCodigo === '') {
        out_doc(['ok'=>false,'error'=>'Debe indicar pre_id | pre_codigo | so_id | so_codigo'], 422);
    }

    if ($preId <= 0 && $preCodigo === '') {
        if ($soCodigo === '' && $soId > 0) {
            $st = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
            $st->execute([$soId]);
            $soCodigo = (string)$st->fetchColumn();
        }
        if ($soCodigo !== '') {
            $preCodigo = 'PRE-' . $soCodigo;
        }
    }

    if ($preId <= 0 && $preCodigo !== '') {
        $st = $pdo->prepare('SELECT id FROM so_preembarque WHERE codigo=? LIMIT 1');
        $st->execute([$preCodigo]);
        $preId = (int)$st->fetchColumn();
    }
    
    if ($preId <= 0) {
        out_doc([
            'ok' => true,
            'pre' => null,
            'has_preembarque' => false,
            'message' => 'No preembarque found yet'
        ]);
    }

    $stH = $pdo->prepare('SELECT pre.id, pre.codigo, pre.pedido_id, pre.deposito_id, pre.zona_posicion_id, p.codigo AS pedido_codigo
                           FROM so_preembarque pre
                           JOIN so_pedido p ON p.id=pre.pedido_id
                           WHERE pre.id=? LIMIT 1');
    $stH->execute([$preId]);
    $hdr = $stH->fetch(PDO::FETCH_ASSOC);
    if (!$hdr) out_doc(['ok'=>false,'error'=>'Pre-embarque no existe'], 404);

    $sql = "
      SELECT sp.id AS pick_id,
             sp.pedido_dest_item_id,
             d.destinatario_id,
             dest.razon_social AS destinatario,
             i.producto_id,
             pr.denominacion AS producto,
             l.codigo AS lote,
             l.fecha_vencimiento AS vto,
             sp.from_pos_id,
             pos.code AS from_pos,
             sp.to_pos_id,
             pos2.code AS to_pos,
             sp.pallet_id,
             sp.uv_cajas,
             sp.uc_unidades
        FROM so_pre_pick sp
        JOIN so_pedido_dest_item i ON i.id=sp.pedido_dest_item_id
        JOIN so_pedido_dest d ON d.id=i.pedido_dest_id
        JOIN para_destinatarios dest ON dest.id=d.destinatario_id
        JOIN para_productos pr ON pr.id=i.producto_id
        LEFT JOIN wh_lote l ON l.id=sp.lote_id
        LEFT JOIN wh_posicion pos ON pos.id=sp.from_pos_id
        LEFT JOIN wh_posicion pos2 ON pos2.id=sp.to_pos_id
       WHERE sp.preembarque_id=?
       ORDER BY ISNULL(l.fecha_vencimiento) ASC, l.fecha_vencimiento ASC, sp.from_pos_id ASC, pr.denominacion ASC
    ";
    $st = $pdo->prepare($sql);
    $st->execute([$preId]);
    $rows = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

    $totUv = 0; $totUc = 0;
    foreach ($rows as $r) { $totUv += (int)($r['uv_cajas'] ?? 0); $totUc += (int)($r['uc_unidades'] ?? 0); }

    out_doc([
        'ok' => true,
        'pre' => [
            'id' => (int)$hdr['id'],
            'codigo' => (string)$hdr['codigo'],
            'pedido_id' => (int)$hdr['pedido_id'],
            'pedido_codigo' => (string)$hdr['pedido_codigo'],
            'deposito_id' => (int)$hdr['deposito_id'],
            'zona_posicion_id' => $hdr['zona_posicion_id'] !== null ? (int)$hdr['zona_posicion_id'] : null,
        ],
        'data' => $rows,
        'totales' => [ 'uv' => $totUv, 'uc' => $totUc ],
    ]);
} catch (Throwable $e) {
    out_doc(['ok'=>false,'error'=>'No se pudo generar el documento','message'=>$e->getMessage()], 500);
}

?>
