<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';
require_once $ROOT . '/app/Support/SoPreparacionErrors.php';

function so_pre_err_out(array $payload, int $status = 200): void
{
    http_response_code($status);
    echo json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
    exit;
}

try {
    $soId = isset($_GET['so_id']) ? (int) $_GET['so_id'] : 0;
    if ($soId <= 0) {
        so_pre_err_out(['ok' => false, 'error' => 'so_id requerido'], 422);
    }

    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec('SET NAMES utf8mb4');

    $tableExists = so_prep_err_table_exists($pdo, so_prep_err_table_name());
    if (!$tableExists) {
        so_pre_err_out([
            'ok' => false,
            'error' => 'Tabla de errores no encontrada. Ejecute la migración correspondiente.',
            'table' => so_prep_err_table_name(),
        ], 500);
    }

    $preInfo = so_prep_err_resolve_pre_info($pdo, $soId);
    $rows = so_prep_err_fetch_rows($pdo, $soId);
    $motivos = so_prep_err_fetch_motivos($pdo);

    so_pre_err_out([
        'ok' => true,
        'rows' => $rows,
        'motivos' => $motivos,
        'pre' => $preInfo,
    ]);
} catch (Throwable $e) {
    so_pre_err_out([
        'ok' => false,
        'error' => 'Error obteniendo registros de errores',
        'message' => $e->getMessage(),
    ], 500);
}
