<?php
declare(strict_types=1);
/*
 * API: Listar movimientos generados por Plan FEFO de un pedido
 * Criterio: wh_move.motivo IN ('PREPARACION','REPOSICION_PICKING') y referencia LIKE 'PRE-%pedido_id%'
 * Entrada: so_id | so_codigo (uno requerido)
 */
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors','0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function respond(array $d, int $c=200){ http_response_code($c); echo json_encode($d, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  $soId = isset($_REQUEST['so_id']) ? (int)$_REQUEST['so_id'] : 0;
  $soCodigo = trim((string)($_REQUEST['so_codigo'] ?? ''));
  if ($soCodigo === '' && $soId>0) {
    $st = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
    $st->execute([$soId]);
    $soCodigo = (string)$st->fetchColumn();
  }
  if ($soId <= 0 && $soCodigo==='') respond(['ok'=>false,'error'=>'Debe indicar so_id o so_codigo'],422);

  // Obtener id para formar referencia
  if ($soId === 0 && $soCodigo!=='') {
    $st = $pdo->prepare('SELECT id FROM so_pedido WHERE codigo=? LIMIT 1');
    $st->execute([$soCodigo]);
    $soId = (int)$st->fetchColumn();
  }
  if ($soId===0) respond(['ok'=>false,'error'=>'Pedido no encontrado'],404);

  // Movimientos
  $sql = "SELECT m.id, m.created_at, m.tipo, m.motivo, m.producto_id, m.lote_id, m.pallet_id,
                 m.from_pos_id, m.to_pos_id, m.delta_uv, m.delta_uc, m.referencia,
                 p.sku AS producto_code, p.denominacion AS producto_nombre,
                 l.codigo AS lote_codigo, l.fecha_vencimiento,
                 pf.code AS from_code, pt.code AS to_code
          FROM wh_move m
          LEFT JOIN para_productos p ON p.id=m.producto_id
          LEFT JOIN wh_lote l ON l.id=m.lote_id
          LEFT JOIN wh_posicion pf ON pf.id=m.from_pos_id
          LEFT JOIN wh_posicion pt ON pt.id=m.to_pos_id
          WHERE m.referencia IN (CONCAT('PRE-', ?), CONCAT('PREP-REP-', ?))
            AND m.motivo IN ('PREPARACION', 'REPOSICION_PICKING')
          ORDER BY m.id DESC";
  $st = $pdo->prepare($sql);
  $st->execute([$soId, $soId]);
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  respond(['ok'=>true,'data'=>$rows,'count'=>count($rows)]);
} catch (Throwable $e) {
  respond(['ok'=>false,'error'=>'No se pudo listar movimientos','message'=>$e->getMessage()],500);
}
