<?php
declare(strict_types=1);

/**
 * API: Obtener tiempos/responsable de PRE (Paso 5)
 * Método: GET
 * Parámetros: pre_id (opcional), so_id (opcional)
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c=200){ http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $preId = isset($_GET['pre_id']) ? (int)$_GET['pre_id'] : 0;
  $soId  = isset($_GET['so_id']) ? (int)$_GET['so_id']  : 0;

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
  $pdo->exec('SET NAMES utf8mb4');

  if ($preId <= 0 && $soId > 0) {
    // Resolver pre_id por so_id
    $st = $pdo->prepare('SELECT codigo FROM so_pedido WHERE id=? LIMIT 1');
    $st->execute([$soId]);
    $soCodigo = $st->fetchColumn();
    if ($soCodigo) {
      $preCode = 'PRE-' . $soCodigo;
      $st2 = $pdo->prepare('SELECT id FROM so_preembarque WHERE codigo=? LIMIT 1');
      $st2->execute([$preCode]);
      $preId = (int)$st2->fetchColumn();
    }
  }

  if ($preId <= 0) {
    out(['ok'=>true,'has_preembarque'=>false]);
  }

  $st = $pdo->prepare('SELECT id, codigo, pedido_id, asignado_at, inicio_at, fin_at, observacion FROM so_preembarque WHERE id=? LIMIT 1');
  $st->execute([$preId]);
  $pre = $st->fetch(PDO::FETCH_ASSOC) ?: null;
  if (!$pre) out(['ok'=>true,'has_preembarque'=>false]);

  // tarea de PREPARACION (si existe)
  $stTP = $pdo->prepare("SELECT id, responsable_user_id, inicio_at, fin_at, foto_url, nota FROM so_pre_tarea WHERE preembarque_id=? AND tipo='PREPARACION' LIMIT 1");
  $stTP->execute([$preId]);
  $tareaPrep = $stTP->fetch(PDO::FETCH_ASSOC) ?: null;

  // tarea de CONTROL (si existe)
  $stTC = $pdo->prepare("SELECT id, responsable_user_id, inicio_at, fin_at, foto_url, nota FROM so_pre_tarea WHERE preembarque_id=? AND tipo='CONTROL' LIMIT 1");
  $stTC->execute([$preId]);
  $tareaCtrl = $stTC->fetch(PDO::FETCH_ASSOC) ?: null;

  // foto por convención si no hay en DB
  $photoPrep = '/storage/preparacion/' . $preId . '.jpg';
  $absPhotoPrep = $ROOT . '/public' . $photoPrep;
  if (($tareaPrep['foto_url'] ?? '') === '' && is_file($absPhotoPrep)) {
    $tareaPrep = $tareaPrep ?: [];
    $tareaPrep['foto_url'] = $photoPrep;
  }
  $photoCtrl = '/storage/preparacion/' . $preId . '-ctrl.jpg';
  $absPhotoCtrl = $ROOT . '/public' . $photoCtrl;
  if (($tareaCtrl['foto_url'] ?? '') === '' && is_file($absPhotoCtrl)) {
    $tareaCtrl = $tareaCtrl ?: [];
    $tareaCtrl['foto_url'] = $photoCtrl;
  }

  out(['ok'=>true,'has_preembarque'=>true,'pre'=>$pre,'tarea_preparacion'=>$tareaPrep,'tarea_control'=>$tareaCtrl]);

} catch (Throwable $e) {
  out(['ok'=>false,'error'=>'Error leyendo tiempos','message'=>$e->getMessage()], 500);
}

?>
