<?php
declare(strict_types=1);

/**
 * API: Cambiar estado de so_pedido
 * Entrada: POST so_id, estado (code en so_pedido_estado)
 * Efecto: setea estado_id al code indicado si existe
 */

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

function out(array $p, int $c = 200): void { http_response_code($c); echo json_encode($p, JSON_UNESCAPED_UNICODE); exit; }

try {
    if (($_SERVER['REQUEST_METHOD'] ?? 'GET') !== 'POST') out(['ok'=>false,'error'=>'Método no permitido'], 405);

    $soId  = (int)($_POST['so_id'] ?? 0);
    $estadoCode = trim((string)($_POST['estado'] ?? ''));
    if ($soId <= 0) out(['ok'=>false,'error'=>'so_id requerido'], 422);
    if ($estadoCode === '') out(['ok'=>false,'error'=>'estado requerido'], 422);

    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->exec("SET NAMES utf8mb4");

    $stE = $pdo->prepare('SELECT id FROM so_pedido_estado WHERE code=? LIMIT 1');
    $stE->execute([$estadoCode]);
    $estadoId = (int)$stE->fetchColumn();
    if ($estadoId <= 0) out(['ok'=>false,'error'=>'Estado inválido'], 422);

    $stU = $pdo->prepare('UPDATE so_pedido SET estado_id=? WHERE id=?');
    $stU->execute([$estadoId, $soId]);

    out(['ok'=>true, 'so_id'=>$soId, 'estado'=>$estadoCode]);
} catch (Throwable $e) {
    out(['ok'=>false,'error'=>'No se pudo actualizar el estado', 'message'=>$e->getMessage()], 500);
}
