<?php
declare(strict_types=1);
header('Content-Type: application/json; charset=utf-8');

require_once dirname(__DIR__, 2) . '/config/db.php';

function out_json($p, int $code=200){ http_response_code($code); echo json_encode($p, JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES); exit; }

try {
  $pdo = getPDO();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (Throwable $e) {
  out_json(['ok'=>false,'error'=>'DB error'], 500);
}

$onlyPicking = isset($_REQUEST['only_picking']) ? (int)$_REQUEST['only_picking'] === 1 : true;
$ignorePalDepo = isset($_REQUEST['ignore_pallet_deposito']) ? ((int)$_REQUEST['ignore_pallet_deposito'] === 1) : false;
$ambCode = isset($_REQUEST['ambiente_code']) ? trim((string)$_REQUEST['ambiente_code']) : '';
$ambLike = isset($_REQUEST['ambiente_like']) ? ((int)$_REQUEST['ambiente_like'] === 1) : false;
$depositoCode = isset($_REQUEST['deposito_code']) ? trim((string)$_REQUEST['deposito_code']) : '';
$depositoId = isset($_REQUEST['deposito_id']) && $_REQUEST['deposito_id'] !== '' ? (int)$_REQUEST['deposito_id'] : null;
$limitPallets = isset($_REQUEST['limit']) && (int)$_REQUEST['limit']>0 ? (int)$_REQUEST['limit'] : null;

// Detect pallet table and position column
$hasTbl = function(PDO $pdo, string $t): bool {
  $st=$pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=?");
  $st->execute([$t]); return (int)$st->fetchColumn()>0;
};
$hasCol = function(PDO $pdo, string $t, string $c): bool {
  $st=$pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME=? AND COLUMN_NAME=?");
  $st->execute([$t,$c]); return (int)$st->fetchColumn()>0;
};

$palTbl = $hasTbl($pdo,'wh_pallet') ? 'wh_pallet' : ($hasTbl($pdo,'wh_pallets') ? 'wh_pallets' : null);
if (!$palTbl) out_json(['ok'=>false,'error'=>'Tabla de pallets no encontrada'], 500);
$posCol = $hasCol($pdo,$palTbl,'posicion_id') ? 'posicion_id' : ($hasCol($pdo,$palTbl,'pos_id') ? 'pos_id' : null);
if (!$posCol) out_json(['ok'=>false,'error'=>'Columna de posición no encontrada'], 500);
$hasDepoPal = $hasCol($pdo,$palTbl,'deposito_id');
$hasDeleted = $hasCol($pdo,$palTbl,'deleted_at');

// Resolve depósito id
if (!$depositoId && $depositoCode!=='') {
  try { $st=$pdo->prepare('SELECT id FROM wh_deposito WHERE codigo=? LIMIT 1'); $st->execute([$depositoCode]); $depositoId = (int)($st->fetchColumn() ?: 0); } catch(Throwable $e){ $depositoId = 0; }
}
if (!$depositoId || $depositoId<=0) {
  // fallback: first depósito
  try { $depositoId = (int)($pdo->query('SELECT id FROM wh_deposito ORDER BY id LIMIT 1')->fetchColumn() ?: 0); } catch(Throwable $e){ $depositoId = 0; }
}
if ($depositoId<=0) out_json(['ok'=>false,'error'=>'No se pudo resolver depósito'], 422);

// Positions eligible
$params=[];
$sqlPos = "SELECT p.id FROM wh_posicion p JOIN wh_ambiente a ON a.id=p.ambiente_id ";
// Ambiente filter
if ($onlyPicking) {
  if ($ambCode === '') { $ambCode = 'PICKING'; }
  if ($ambLike) { $sqlPos .= "AND a.code LIKE ? "; $params[] = $ambCode; }
  else { $sqlPos .= "AND a.code = ? "; $params[] = $ambCode; }
}
$sqlPos .= " WHERE 1=1";
if ($hasCol($pdo,'wh_posicion','deposito_id')) { $sqlPos .= " AND p.deposito_id=?"; $params[]=$depositoId; }
$posStmt = $pdo->prepare($sqlPos); $posStmt->execute($params);
$posIds = $posStmt->fetchAll(PDO::FETCH_COLUMN,0);
if (!$posIds) out_json(['ok'=>true,'message'=>'No hay posiciones destino elegibles','updated'=>0]);

// Find pallets located in those positions
$inList = implode(',', array_map('intval', $posIds));
$where = ["{$posCol} IN ($inList)"];
$paramsPal = [];
if ($hasDepoPal && !$ignorePalDepo) { $where[] = 'deposito_id = ?'; $paramsPal[] = $depositoId; }
if ($hasDeleted)  { $where[] = 'deleted_at IS NULL'; }
$sqlPals = "SELECT id, {$posCol} AS pos_id " . ($hasDepoPal?", deposito_id":', NULL AS deposito_id') . " AS deposito_id FROM {$palTbl} WHERE " . implode(' AND ', $where) . " ORDER BY id" . ($limitPallets?" LIMIT ".$limitPallets:'');
$palStmt = $pdo->prepare($sqlPals); $palStmt->execute($paramsPal);
$pallets = $palStmt->fetchAll(PDO::FETCH_ASSOC);
if (!$pallets) out_json(['ok'=>true,'message'=>'No hay pallets ubicados para sincronizar','updated'=>0]);

// Prepare helpers for wh_stock updates
$stStock = $pdo->prepare("SELECT id, producto_id, lote_id, posicion_id, qty_uv, qty_uc FROM wh_stock WHERE deposito_id=? AND pallet_id=? AND (qty_uv>0 OR qty_uc>0)");
$stFindTgt = $pdo->prepare("SELECT id FROM wh_stock WHERE deposito_id=? AND producto_id=? AND (lote_id <=> ?) AND (pallet_id <=> ?) AND posicion_id=? LIMIT 1");
$stUpdMerge = $pdo->prepare("UPDATE wh_stock SET qty_uv=qty_uv+?, qty_uc=qty_uc+? WHERE id=?");
$stUpdPos   = $pdo->prepare("UPDATE wh_stock SET posicion_id=? WHERE id=?");
$stInsRow   = $pdo->prepare("INSERT INTO wh_stock (deposito_id, posicion_id, producto_id, lote_id, pallet_id, qty_uv, qty_uc) VALUES (?,?,?,?,?,?,?)");

$updated=0; $merged=0; $inserted=0; $movedRows=0; $palletsTouched=0;

$pdo->beginTransaction();
try {
  foreach ($pallets as $pal) {
    $pid = (int)$pal['id']; $toPos = (int)$pal['pos_id'];
    $stStock->execute([$depositoId, $pid]);
    $foundAny=false;
    while($s = $stStock->fetch(PDO::FETCH_ASSOC)){
      $fromPos = (int)($s['posicion_id'] ?? 0);
      $duv = (int)($s['qty_uv'] ?? 0); $duc = (int)($s['qty_uc'] ?? 0);
      if ($duv===0 && $duc===0) continue;
      if ($fromPos === $toPos) continue;
      $foundAny=true; $movedRows++;
      $prodId = (int)($s['producto_id'] ?? 0); $loteId = ($s['lote_id']!==null ? (int)$s['lote_id'] : null);
      $stFindTgt->execute([$depositoId, $prodId, $loteId, $pid, $toPos]);
      $tgtId = (int)($stFindTgt->fetchColumn() ?: 0);
      if ($tgtId>0){ $stUpdMerge->execute([$duv,$duc,$tgtId]); $merged += $stUpdMerge->rowCount(); }
      else { $stUpdPos->execute([$toPos, (int)$s['id']]); $updated += $stUpdPos->rowCount(); if ($stUpdPos->rowCount()===0){ $stInsRow->execute([$depositoId,$toPos,$prodId,$loteId,$pid,$duv,$duc]); $inserted += $stInsRow->rowCount(); } }
    }
    if ($foundAny) $palletsTouched++;
  }
  $pdo->commit();
} catch (Throwable $e) {
  $pdo->rollBack();
  out_json(['ok'=>false,'error'=>'Error al sincronizar','message'=>$e->getMessage()], 500);
}

out_json([
  'ok'=>true,
  'deposito_id'=>$depositoId,
  'only_picking'=>$onlyPicking,
  'pallets_touched'=>$palletsTouched,
  'rows_scanned'=> $movedRows,
  'rows_pos_updated'=>$updated,
  'rows_merged'=>$merged,
  'rows_inserted'=>$inserted,
]);
