<?php
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/config.php';
require_once $ROOT . '/config/db.php';

try {
    $start = microtime(true);
    
    $pdo = get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Test simple query
    $stmt = $pdo->query('SELECT NOW() as now_time, CONNECTION_ID() as connection_id');
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    $end = microtime(true);
    $duration = round(($end - $start) * 1000, 2);
    
    echo json_encode([
        'ok' => true,
        'message' => 'Connection test successful',
        'duration_ms' => $duration,
        'server_info' => $result,
        'timestamp' => date('Y-m-d H:i:s')
    ], JSON_UNESCAPED_UNICODE);
    
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok' => false,
        'error' => 'Connection test failed',
        'message' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
?>