<?php
declare(strict_types=1);
// api/parametros/ambientes.php
// Returns list of ambientes. Optional GET param: deposito_id to filter ambientes used in that deposito.

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2); // /api/parametros -> up 2 = project root
require_once $ROOT . '/config/db.php';

$deposito_id = isset($_GET['deposito_id']) ? (int)$_GET['deposito_id'] : null;

try {
  $pdo = getPDO();
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'db','msg'=>$e->getMessage()]);
  exit;
}

try {
  if ($deposito_id && $deposito_id>0) {
    $st = $pdo->prepare("SELECT DISTINCT a.id, a.code, a.nombre FROM wh_ambiente a JOIN wh_posicion p ON p.ambiente_id = a.id WHERE p.deposito_id = ? ORDER BY a.code");
    $st->execute([$deposito_id]);
  } else {
    $st = $pdo->prepare("SELECT id, code, nombre FROM wh_ambiente ORDER BY code");
    $st->execute();
  }
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode($rows, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'query','msg'=>$e->getMessage()]);
}
