<?php
// api/parametros/choferes.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/db.php';
require_once $ROOT . '/app/Support/ApiHelpers.php';
// Ensure a PDO instance is available
$pdo = getPDO();

try {
  // Support optional query (q) for searching by nombre and optional id for single lookup
  $q = isset($_GET['q']) ? trim((string)$_GET['q']) : null;
  $id = isset($_GET['id']) ? trim((string)$_GET['id']) : null;
  // Determine which table to use: prefer para_choferes, fallback to pl_chofer
  $tbl = null;
  $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'para_choferes'");
  $st->execute();
  if ((int)$st->fetchColumn() > 0) {
    $tbl = 'para_choferes';
    $label = 'nombre';
  } else {
    $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'pl_chofer'");
    $st->execute();
    if ((int)$st->fetchColumn() > 0) {
      $tbl = 'pl_chofer';
      $label = columnExists($pdo, 'pl_chofer', 'nombre') ? 'nombre' : 'id';
    }
  }

  if (!$tbl) {
    echo json_encode(['data' => []], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($id !== null && $id !== '') {
    $sql = "SELECT id, {$label} AS nombre FROM {$tbl} WHERE id = :id";
    if (columnExists($pdo, $tbl, 'deleted_at')) $sql .= " AND deleted_at IS NULL";
    $sql .= " LIMIT 1";
    $st = $pdo->prepare($sql);
    $st->execute([':id' => $id]);
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['data' => $rows], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($q !== null && $q !== '') {
    $like = "%{$q}%";
    $sql = "SELECT id, {$label} AS nombre FROM {$tbl} WHERE 1=1";
    if (columnExists($pdo, $tbl, 'deleted_at')) $sql .= " AND deleted_at IS NULL";
    $sql .= " AND {$label} LIKE :q ORDER BY {$label} LIMIT 50";
    $st = $pdo->prepare($sql);
    $st->execute([':q' => $like]);
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['data' => $rows], JSON_UNESCAPED_UNICODE);
    exit;
  }

  $sql = "SELECT id, {$label} AS nombre FROM {$tbl} WHERE 1=1";
  if (columnExists($pdo, $tbl, 'deleted_at')) $sql .= " AND deleted_at IS NULL";
  $sql .= " ORDER BY {$label} LIMIT 200";
  $st = $pdo->prepare($sql);
  $st->execute();
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode(['data' => $rows], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error' => 'Error del servidor', 'message' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}

