<?php
// api/parametros/clientes.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

// En dev puedes mostrar errores, pero evita E_DEPRECATED que rompe JSON
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0'); // prod: 0; dev: 1 (pero sin E_DEPRECATED)

// Raíz del proyecto (estás en /api/parametros → subir 2 niveles)
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/vendor/Editor/lib/DataTables.php';

use
    DataTables\Editor,
    DataTables\Editor\Field,
    DataTables\Editor\Format,
    DataTables\Editor\Mjoin,
    DataTables\Editor\Options,
    DataTables\Editor\Upload,
    DataTables\Editor\Validate,
    DataTables\Editor\ValidateOptions;

try {
  // Editor para para_clientes
  $editor = Editor::inst($db, 'para_clientes', 'para_clientes.id')
    ->fields(
      // PK
      Field::inst('para_clientes.id')->set(false),

      // Datos principales
      Field::inst('para_clientes.razon_social')
        ->validator(
          Validate::notEmpty(
            ValidateOptions::inst()->message('La razón social es requerida.')
          )
        ),
      Field::inst('para_clientes.ruc'),

      // Estado
      Field::inst('para_clientes.activo'),

      // Auditoría (readonly desde cliente)
      Field::inst('para_clientes.created_at')->set(false),
      Field::inst('para_clientes.updated_at')->set(false),
      Field::inst('para_clientes.deleted_at')->set(false),
      Field::inst('para_clientes.created_by')->set(false),
      Field::inst('para_clientes.updated_by')->set(false),
      Field::inst('para_clientes.deleted_by')->set(false)
    )

    // Filtro: sin borrados lógicos
    ->where('para_clientes.deleted_at', null)
    
    // Depuración
    ->debug(false);

  $editor->process($_POST)->json();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'error'   => 'Error del servidor',
    'message' => $e->getMessage(),
  ], JSON_UNESCAPED_UNICODE);
}
