<?php
declare(strict_types=1);
// api/parametros/depositos.php
// Returns list of depósitos: id, code, nombre

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2); // /api/parametros -> project root
require_once $ROOT . '/config/db.php';

try {
  $pdo = getPDO();
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'db','msg'=>$e->getMessage()]);
  exit;
}

try {
  $st = $pdo->prepare('SELECT id, code, nombre FROM wh_deposito ORDER BY id');
  $st->execute();
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode($rows, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error'=>'query','msg'=>$e->getMessage()]);
}
