<?php
// api/parametros/destinatarios.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

// Raíz del proyecto
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/vendor/Editor/lib/DataTables.php';

use
  DataTables\Editor,
  DataTables\Editor\Field,
  DataTables\Editor\Options,
  DataTables\Editor\Validate,
  DataTables\Editor\ValidateOptions;

try {
  $editor = Editor::inst($db, 'para_destinatarios', 'para_destinatarios.id')
    ->fields(
      // PK
      Field::inst('para_destinatarios.id')->set(false),

      // Básicos
      Field::inst('para_destinatarios.cod')
        ->validator(
          Validate::notEmpty(
            ValidateOptions::inst()->message('El código es requerido.')
          )
        ),
      Field::inst('para_destinatarios.nombre')
        ->validator(
          Validate::notEmpty(
            ValidateOptions::inst()->message('El nombre es requerido.')
          )
        ),
      Field::inst('para_destinatarios.fantasia'),
      Field::inst('para_destinatarios.razon_social'),
      Field::inst('para_destinatarios.telefono'),
      Field::inst('para_destinatarios.direccion'),

      // FKs + Options (labels)
      Field::inst('para_destinatarios.cliente_id')
        ->options(
          Options::inst()
            ->table('para_clientes')
            ->value('id')
            ->label('razon_social')
            ->order('razon_social asc')
            ->where(fn($q) => $q->where('deleted_at', null, '='))
        )
        ->validator(Validate::dbValues()),

      Field::inst('para_destinatarios.ciudad_id')
        ->options(
          Options::inst()
            ->table('para_ciudades')            // ajusta si tu tabla difiere
            ->value('id')
            ->label('nombre')                   // ajusta si el label difiere
            ->order('nombre asc')
        )
        ->validator(Validate::dbValues()),

      // Contactos
      Field::inst('para_destinatarios.contacto_destinatario'),
      Field::inst('para_destinatarios.contacto_vendedor'),

      // Auditoría (readonly)
      Field::inst('para_destinatarios.created_at')->set(false),
      Field::inst('para_destinatarios.updated_at')->set(false),
      Field::inst('para_destinatarios.deleted_at')->set(false),

      // Campos JOIN para mostrar labels en la tabla (read-only)
      Field::inst('para_clientes.razon_social')->set(false),
      Field::inst('para_ciudades.nombre')->set(false),
    )

    // LEFT JOINs para labels
    ->leftJoin('para_clientes',             'para_clientes.id',            '=', 'para_destinatarios.cliente_id')
    ->leftJoin('para_ciudades',             'para_ciudades.id',            '=', 'para_destinatarios.ciudad_id')

    // Sin borrados lógicos
    ->where('para_destinatarios.deleted_at', null)


    ->debug(false);

  $editor->process($_POST)->json();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'error'   => 'Error del servidor',
    'message' => $e->getMessage(),
  ], JSON_UNESCAPED_UNICODE);
}
