<?php
// api/parametros/grupos.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

// Evitar E_DEPRECATED que rompe JSON en PHP 8.x
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0'); // prod: 0; dev: 1 (sin E_DEPRECATED)

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/vendor/Editor/lib/DataTables.php';

use
  DataTables\Editor,
  DataTables\Editor\Field,
  DataTables\Editor\Validate,
  DataTables\Editor\ValidateOptions;

try {
  // Editor para para_grupos
  $editor = Editor::inst($db, 'para_grupos', 'para_grupos.id')
    ->fields(
      // PK
      Field::inst('para_grupos.id')->set(false),

      // Datos
      Field::inst('para_grupos.nombre')
        ->validator(
          Validate::notEmpty(
            ValidateOptions::inst()->message('El nombre es requerido.')
          )
        )
        // Respetar UNIQUE (uq_para_grupos_nombre)
        ->validator(
          Validate::unique(
            ValidateOptions::inst()->message('El nombre ya existe.')
          )
        ),
      Field::inst('para_grupos.descripcion'),
      Field::inst('para_grupos.activo'),

      // Auditoría (readonly desde cliente)
      Field::inst('para_grupos.created_at')->set(false),
      Field::inst('para_grupos.updated_at')->set(false),
      Field::inst('para_grupos.deleted_at')->set(false),
      Field::inst('para_grupos.created_by')->set(false),
      Field::inst('para_grupos.updated_by')->set(false),
      Field::inst('para_grupos.deleted_by')->set(false)
    )

    // Filtrar borrado lógico
    ->where('para_grupos.deleted_at', null)

    // Depuración
    ->debug(false);

  $editor->process($_POST)->json();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'error'   => 'Error del servidor',
    'message' => $e->getMessage(),
  ], JSON_UNESCAPED_UNICODE);
}
