<?php
// api/parametros/moviles.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

// Raíz del proyecto (desde /api/parametros → subir 2 niveles)
$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/vendor/Editor/lib/DataTables.php';

use
  DataTables\Editor,
  DataTables\Editor\Field,
  DataTables\Editor\Options,
  DataTables\Editor\Validate,
  DataTables\Editor\ValidateOptions;

try {
  $editor = Editor::inst($db, 'para_moviles', 'para_moviles.id')
    ->fields(
      // PK
      Field::inst('para_moviles.id')->set(false),

      // Datos principales
      Field::inst('para_moviles.chapa')
        ->validator(
          Validate::notEmpty(
            ValidateOptions::inst()->message('La chapa es requerida.')
          )
        ),
      Field::inst('para_moviles.tipo_id')
        ->options(
          Options::inst()
            ->table('para_movil_tipos')  // ⬅️ Ajusta si tu catálogo difiere (p.ej. para_moviles_tipos)
            ->value('id')
            ->label('nombre')
            ->order('nombre asc')
        )
        ->validator(Validate::dbValues(
          ValidateOptions::inst()->message('Seleccione un tipo válido.')
        )),

      // Datos extra
      Field::inst('para_moviles.gps'), // varchar(150) nullable
      Field::inst('para_moviles.transportadora_id')
        ->options(
          Options::inst()
            ->table('para_transportadoras') // ⬅️ Ajusta si tu catálogo difiere
            ->value('id')
            ->label('nombre')
            ->order('nombre asc')
        )
        ->validator(Validate::dbValues()),

      // Auditoría (readonly desde cliente)
      Field::inst('para_moviles.created_at')->set(false),
      Field::inst('para_moviles.updated_at')->set(false),
      Field::inst('para_moviles.deleted_at')->set(false),

      // Labels de los JOIN para mostrar en la tabla (solo lectura)
      Field::inst('para_movil_tipos.nombre')->set(false),
      Field::inst('para_transportadoras.nombre')->set(false)
    )

    // JOINs para labels
    ->leftJoin('para_movil_tipos',     'para_movil_tipos.id',     '=', 'para_moviles.tipo_id')
    ->leftJoin('para_transportadoras', 'para_transportadoras.id', '=', 'para_moviles.transportadora_id')

    // Sin borrados lógicos
    ->where('para_moviles.deleted_at', null)


    ->debug(false);

  $editor->process($_POST)->json();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'error'   => 'Error del servidor',
    'message' => $e->getMessage(),
  ], JSON_UNESCAPED_UNICODE);
}
