<?php
// api/parametros/moviles_select.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/config/db.php';
require_once $ROOT . '/app/Support/ApiHelpers.php';
// Ensure a PDO instance is available
$pdo = getPDO();

try {
  $q = isset($_GET['q']) ? trim((string)$_GET['q']) : null;
  $id = isset($_GET['id']) ? trim((string)$_GET['id']) : null;
  // Determine which table to use: prefer para_moviles, fallback to pl_movil
  $tbl = null;
  $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'para_moviles'");
  $st->execute();
  if ((int)$st->fetchColumn() > 0) {
    $tbl = 'para_moviles';
    $colLabel = 'chapa';
  } else {
    $st = $pdo->prepare("SELECT COUNT(*) FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'pl_movil'");
    $st->execute();
    if ((int)$st->fetchColumn() > 0) {
      $tbl = 'pl_movil';
      // pl_movil uses 'patente' as label in schema; map to chapa for compatibility
      $colLabel = (columnExists($pdo, 'pl_movil', 'patente') ? 'patente' : (columnExists($pdo, 'pl_movil', 'chapa') ? 'chapa' : 'id'));
    }
  }

  if (!$tbl) {
    // No suitable table: return empty
    echo json_encode(['data' => []], JSON_UNESCAPED_UNICODE);
    exit;
  }

  // Helper to build queries safely
  if ($id !== null && $id !== '') {
    $sql = "SELECT id, {$colLabel} AS chapa FROM {$tbl} WHERE id = :id";
    // if deleted_at column exists, filter it
    if (columnExists($pdo, $tbl, 'deleted_at')) $sql .= " AND deleted_at IS NULL";
    $sql .= " LIMIT 1";
    $st = $pdo->prepare($sql);
    $st->execute([':id' => $id]);
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['data' => $rows], JSON_UNESCAPED_UNICODE);
    exit;
  }

  if ($q !== null && $q !== '') {
    $like = "%{$q}%";
    $sql = "SELECT id, {$colLabel} AS chapa FROM {$tbl} WHERE 1=1";
    if (columnExists($pdo, $tbl, 'deleted_at')) $sql .= " AND deleted_at IS NULL";
    $sql .= " AND ({$colLabel} LIKE :q OR {$colLabel} LIKE :q2) ORDER BY {$colLabel} LIMIT 50";
    $st = $pdo->prepare($sql);
    $st->execute([':q' => $like, ':q2' => $like]);
    $rows = $st->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['data' => $rows], JSON_UNESCAPED_UNICODE);
    exit;
  }

  // Default list
  $sql = "SELECT id, {$colLabel} AS chapa FROM {$tbl} WHERE 1=1";
  if (columnExists($pdo, $tbl, 'deleted_at')) $sql .= " AND deleted_at IS NULL";
  $sql .= " ORDER BY {$colLabel} LIMIT 200";
  $st = $pdo->prepare($sql);
  $st->execute();
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);
  echo json_encode(['data' => $rows], JSON_UNESCAPED_UNICODE);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['error' => 'Error del servidor', 'message' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
