<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';

if (empty($_SESSION['usuario_id'])) {
  http_response_code(401);
  echo json_encode(['ok' => false, 'error' => 'No autorizado']);
  exit;
}

try {
  $id = (int)($_GET['id'] ?? 0);
  
  if ($id <= 0) {
    throw new InvalidArgumentException('ID inválido');
  }

  $pdo = get_pdo();
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

  $sql = "SELECT 
            p.id,
            p.sku,
            p.denominacion,
            (SELECT unidades_por_uv FROM para_producto_pack WHERE producto_id = p.id LIMIT 1) AS unidades_por_caja,
            (SELECT cajas_por_pallet FROM para_producto_paletizado WHERE producto_id = p.id LIMIT 1) AS cajas_por_pallet
          FROM para_productos p
          WHERE p.id = :id";
  
  $st = $pdo->prepare($sql);
  $st->execute([':id' => $id]);
  
  $row = $st->fetch(PDO::FETCH_ASSOC);
  
  if (!$row) {
    http_response_code(404);
    echo json_encode(['ok' => false, 'error' => 'Producto no encontrado']);
    exit;
  }

  echo json_encode(['ok' => true, 'data' => $row]);

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'ok' => false,
    'error' => $e->getMessage()
  ]);
}
