<?php
// api/parametros/transportadoras.php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', '0');

$ROOT = dirname(__DIR__, 2);
require_once $ROOT . '/vendor/Editor/lib/DataTables.php';

use
  DataTables\Editor,
  DataTables\Editor\Field,
  DataTables\Editor\Validate,
  DataTables\Editor\ValidateOptions;

try {
  $editor = Editor::inst($db, 'para_transportadoras', 'para_transportadoras.id')
    ->fields(
      Field::inst('para_transportadoras.id')->set(false),

      Field::inst('para_transportadoras.nombre')
        ->validator(
          Validate::notEmpty(
            ValidateOptions::inst()->message('El nombre de la transportadora es requerido.')
          )
        ),

      // Auditoría
      Field::inst('para_transportadoras.created_at')->set(false),
      Field::inst('para_transportadoras.updated_at')->set(false),
      Field::inst('para_transportadoras.deleted_at')->set(false)
    )
    ->where('para_transportadoras.deleted_at', null)
    ->debug(false);

  $editor->process($_POST)->json();

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'error'   => 'Error del servidor',
    'message' => $e->getMessage(),
  ], JSON_UNESCAPED_UNICODE);
}
