<?php
declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');

$BASE = dirname(__DIR__, 2);
require_once $BASE . '/config/config.php';
require_once $BASE . '/config/db.php';
require_once $BASE . '/app/Support/Reportes/AlmacenamientoReport.php';

if (empty($_SESSION['usuario_id'])) {
    http_response_code(401);
    echo json_encode(['ok' => false, 'error' => 'No autorizado'], JSON_UNESCAPED_UNICODE);
    exit;
}

try {
    $pdo = function_exists('getPDO') ? getPDO() : get_pdo();
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    if (isset($_GET['meta'])) {
        $meta = strtolower(trim((string) $_GET['meta']));
        if ($meta === 'depositos') {
            echo json_encode(['ok' => true, 'depositos' => almacenamiento_fetch_depositos($pdo)], JSON_UNESCAPED_UNICODE);
            return;
        }
        if ($meta === 'clientes') {
            echo json_encode(['ok' => true, 'clientes' => almacenamiento_fetch_clientes($pdo)], JSON_UNESCAPED_UNICODE);
            return;
        }
        if (in_array($meta, ['filters', 'combos'], true)) {
            echo json_encode(['ok' => true] + almacenamiento_fetch_filters($pdo), JSON_UNESCAPED_UNICODE);
            return;
        }
    }

    $data = almacenamiento_fetch_data($pdo, $_GET);
    echo json_encode(['ok' => true] + $data, JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    http_response_code(500);
    echo json_encode([
        'ok'    => false,
        'error' => 'Error al generar el reporte de almacenamiento',
        'msg'   => env('APP_ENV') === 'local' ? $e->getMessage() : '',
    ], JSON_UNESCAPED_UNICODE);
}
